/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import io.grpc.Channel;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import java.io.Closeable;
import org.apache.hugegraph.pd.client.AbstractClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.GraphSpaces;
import org.apache.hugegraph.pd.grpc.Graphs;
import org.apache.hugegraph.pd.grpc.MetaServiceGrpc;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Partitions;
import org.apache.hugegraph.pd.grpc.ShardGroups;
import org.apache.hugegraph.pd.grpc.Stores;
import org.apache.hugegraph.pd.grpc.VoidResponse;
import org.apache.hugegraph.pd.grpc.common.NoArg;

public class MetaClient
extends AbstractClient
implements Closeable {
    public MetaClient(PDConfig config) {
        super(config);
    }

    @Override
    protected AbstractStub createStub() {
        return MetaServiceGrpc.newStub((Channel)this.channel);
    }

    @Override
    protected AbstractBlockingStub createBlockingStub() {
        return MetaServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public Stores getStores() throws PDException {
        Stores res = (Stores)this.blockingUnaryCall(MetaServiceGrpc.getGetStoresMethod(), NoArg.newBuilder().build());
        MetaClient.handleErrors(res.getHeader());
        return res;
    }

    public Partitions getPartitions() throws PDException {
        Partitions res = (Partitions)this.blockingUnaryCall(MetaServiceGrpc.getGetPartitionsMethod(), NoArg.newBuilder().build());
        MetaClient.handleErrors(res.getHeader());
        return res;
    }

    public ShardGroups getShardGroups() throws PDException {
        ShardGroups res = (ShardGroups)this.blockingUnaryCall(MetaServiceGrpc.getGetShardGroupsMethod(), NoArg.newBuilder().build());
        MetaClient.handleErrors(res.getHeader());
        return res;
    }

    public GraphSpaces getGraphSpaces() throws PDException {
        GraphSpaces res = (GraphSpaces)this.blockingUnaryCall(MetaServiceGrpc.getGetGraphSpacesMethod(), NoArg.newBuilder().build());
        MetaClient.handleErrors(res.getHeader());
        return res;
    }

    public Graphs getGraphs() throws PDException {
        Graphs res = (Graphs)this.blockingUnaryCall(MetaServiceGrpc.getGetGraphsMethod(), NoArg.newBuilder().build());
        MetaClient.handleErrors(res.getHeader());
        return res;
    }

    public void updateStore(Metapb.Store request) throws PDException {
        VoidResponse res = (VoidResponse)this.blockingUnaryCall(MetaServiceGrpc.getUpdateStoreMethod(), request);
        MetaClient.handleErrors(res.getHeader());
    }

    public void updatePartition(Metapb.Partition request) throws PDException {
        VoidResponse res = (VoidResponse)this.blockingUnaryCall(MetaServiceGrpc.getUpdatePartitionMethod(), request);
        MetaClient.handleErrors(res.getHeader());
    }

    public void updateShardGroup(Metapb.ShardGroup request) throws PDException {
        VoidResponse res = (VoidResponse)this.blockingUnaryCall(MetaServiceGrpc.getUpdateShardGroupMethod(), request);
        MetaClient.handleErrors(res.getHeader());
    }

    public void updateGraphSpace(Metapb.GraphSpace request) throws PDException {
        VoidResponse res = (VoidResponse)this.blockingUnaryCall(MetaServiceGrpc.getUpdateGraphSpaceMethod(), request);
        MetaClient.handleErrors(res.getHeader());
    }

    public void updateGraph(Metapb.Graph request) throws PDException {
        VoidResponse res = (VoidResponse)this.blockingUnaryCall(MetaServiceGrpc.getUpdateGraphMethod(), request);
        MetaClient.handleErrors(res.getHeader());
    }

    @Override
    public void close() {
        super.close();
    }
}

