/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.extractor;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.IWord;

public abstract class KeyphraseExtractor {
    protected ISegment seg;

    public KeyphraseExtractor(ISegment seg) {
        this.seg = seg;
    }

    protected boolean filter(IWord word) {
        switch (word.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                return false;
            }
        }
        String[] poss = word.getPartSpeech();
        if (poss == null) {
            return true;
        }
        char pos = poss[0].charAt(0);
        switch (pos) {
            case 'e': {
                return poss[0].equals("en");
            }
            case 'b': 
            case 'c': 
            case 'd': 
            case 'g': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 'u': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return false;
            }
        }
        return true;
    }

    public List<String> getKeyphraseFromString(String doc) throws IOException {
        return this.getKeyphrase(new StringReader(doc));
    }

    public List<String> getKeyphraseFromFile(String file) throws IOException {
        return this.getKeyphrase(new FileReader(file));
    }

    public abstract List<String> getKeyphrase(Reader var1) throws IOException;

    public ISegment getSeg() {
        return this.seg;
    }

    public void setSeg(ISegment seg) {
        this.seg = seg;
    }
}

