/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.pool;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.fury.AbstractThreadSafeFury;
import org.apache.fury.Fury;
import org.apache.fury.annotation.Internal;
import org.apache.fury.io.FuryInputStream;
import org.apache.fury.io.FuryReadableChannel;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.apache.fury.pool.ClassLoaderFuryPooled;
import org.apache.fury.pool.FuryPooledObjectFactory;
import org.apache.fury.resolver.ClassChecker;
import org.apache.fury.serializer.BufferCallback;
import org.apache.fury.util.LoaderBinding;

@ThreadSafe
public class ThreadPoolFury
extends AbstractThreadSafeFury {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolFury.class);
    private final FuryPooledObjectFactory furyPooledObjectFactory;
    private Consumer<Fury> factoryCallback = f -> {};

    public ThreadPoolFury(Function<ClassLoader, Fury> furyFactory, int minPoolSize, int maxPoolSize, long expireTime, TimeUnit timeUnit) {
        this.furyPooledObjectFactory = new FuryPooledObjectFactory(furyFactory, minPoolSize, maxPoolSize, expireTime, timeUnit, fury -> this.factoryCallback.accept((Fury)fury));
    }

    @Override
    @Internal
    public void registerCallback(Consumer<Fury> callback) {
        this.factoryCallback = this.factoryCallback.andThen(callback);
        for (ClassLoaderFuryPooled furyPooled : this.furyPooledObjectFactory.classLoaderFuryPooledCache.asMap().values()) {
            furyPooled.allFury.keySet().forEach(callback);
        }
    }

    @Override
    public <R> R execute(Function<Fury, R> action) {
        ClassLoaderFuryPooled pooledCache = null;
        Fury fury = null;
        try {
            pooledCache = this.furyPooledObjectFactory.getPooledCache();
            fury = pooledCache.getFury();
            R r = action.apply(fury);
            return r;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        finally {
            if (pooledCache != null) {
                pooledCache.returnFury(fury);
            }
        }
    }

    @Override
    public byte[] serialize(Object obj) {
        return this.execute(fury -> fury.serialize(obj));
    }

    @Override
    public byte[] serialize(Object obj, BufferCallback callback) {
        return this.execute(fury -> fury.serialize(obj, callback));
    }

    @Override
    public MemoryBuffer serialize(Object obj, long address, int size) {
        return this.execute(fury -> fury.serialize(obj, address, size));
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj) {
        return this.execute(fury -> fury.serialize(buffer, obj));
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj, BufferCallback callback) {
        return this.execute(fury -> fury.serialize(buffer, obj, callback));
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj) {
        this.execute(fury -> {
            fury.serialize(outputStream, obj);
            return null;
        });
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj, BufferCallback callback) {
        this.execute(fury -> {
            fury.serialize(outputStream, obj, callback);
            return null;
        });
    }

    @Override
    public Object deserialize(byte[] bytes) {
        return this.execute(fury -> fury.deserialize(bytes));
    }

    @Override
    public Object deserialize(byte[] bytes, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.execute(fury -> fury.deserialize(bytes, outOfBandBuffers));
    }

    @Override
    public Object deserialize(long address, int size) {
        return this.execute(fury -> fury.deserialize(address, size));
    }

    @Override
    public Object deserialize(MemoryBuffer buffer) {
        return this.execute(fury -> fury.deserialize(buffer));
    }

    @Override
    public Object deserialize(ByteBuffer byteBuffer) {
        return this.execute(fury -> fury.deserialize(MemoryUtils.wrap(byteBuffer)));
    }

    @Override
    public Object deserialize(MemoryBuffer buffer, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.execute(fury -> fury.deserialize(buffer, outOfBandBuffers));
    }

    @Override
    public Object deserialize(FuryInputStream inputStream) {
        return this.execute(fury -> fury.deserialize(inputStream));
    }

    @Override
    public Object deserialize(FuryInputStream inputStream, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.execute(fury -> fury.deserialize(inputStream, outOfBandBuffers));
    }

    @Override
    public Object deserialize(FuryReadableChannel channel) {
        return this.execute(fury -> fury.deserialize(channel));
    }

    @Override
    public Object deserialize(FuryReadableChannel channel, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.execute(fury -> fury.deserialize(channel, outOfBandBuffers));
    }

    @Override
    public byte[] serializeJavaObject(Object obj) {
        return this.execute(fury -> fury.serializeJavaObject(obj));
    }

    @Override
    public void serializeJavaObject(MemoryBuffer buffer, Object obj) {
        this.execute(fury -> {
            fury.serializeJavaObject(buffer, obj);
            return null;
        });
    }

    @Override
    public void serializeJavaObject(OutputStream outputStream, Object obj) {
        this.execute(fury -> {
            fury.serializeJavaObject(outputStream, obj);
            return null;
        });
    }

    @Override
    public <T> T deserializeJavaObject(byte[] data, Class<T> cls) {
        return (T)this.execute(fury -> fury.deserializeJavaObject(data, cls));
    }

    @Override
    public <T> T deserializeJavaObject(MemoryBuffer buffer, Class<T> cls) {
        return (T)this.execute(fury -> fury.deserializeJavaObject(buffer, cls));
    }

    @Override
    public <T> T deserializeJavaObject(FuryInputStream inputStream, Class<T> cls) {
        return (T)this.execute(fury -> fury.deserializeJavaObject(inputStream, cls));
    }

    @Override
    public <T> T deserializeJavaObject(FuryReadableChannel channel, Class<T> cls) {
        return (T)this.execute(fury -> fury.deserializeJavaObject(channel, cls));
    }

    @Override
    public byte[] serializeJavaObjectAndClass(Object obj) {
        return this.execute(fury -> fury.serializeJavaObjectAndClass(obj));
    }

    @Override
    public void serializeJavaObjectAndClass(MemoryBuffer buffer, Object obj) {
        this.execute(fury -> {
            fury.serializeJavaObjectAndClass(buffer, obj);
            return null;
        });
    }

    @Override
    public void serializeJavaObjectAndClass(OutputStream outputStream, Object obj) {
        this.execute(fury -> {
            fury.serializeJavaObjectAndClass(outputStream, obj);
            return null;
        });
    }

    @Override
    public Object deserializeJavaObjectAndClass(byte[] data) {
        return this.execute(fury -> fury.deserializeJavaObjectAndClass(data));
    }

    @Override
    public Object deserializeJavaObjectAndClass(MemoryBuffer buffer) {
        return this.execute(fury -> fury.deserializeJavaObjectAndClass(buffer));
    }

    @Override
    public Object deserializeJavaObjectAndClass(FuryInputStream inputStream) {
        return this.execute(fury -> fury.deserializeJavaObjectAndClass(inputStream));
    }

    @Override
    public Object deserializeJavaObjectAndClass(FuryReadableChannel channel) {
        return this.execute(fury -> fury.deserializeJavaObjectAndClass(channel));
    }

    @Override
    public <T> T copy(T obj) {
        return (T)this.execute(fury -> fury.copy(obj));
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader, LoaderBinding.StagingType.SOFT_STAGING);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
        this.furyPooledObjectFactory.setClassLoader(classLoader, stagingType);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.furyPooledObjectFactory.getClassLoader();
    }

    @Override
    public void setClassChecker(ClassChecker classChecker) {
        this.execute(fury -> {
            fury.getClassResolver().setClassChecker(classChecker);
            return null;
        });
    }

    @Override
    public void clearClassLoader(ClassLoader loader) {
        this.furyPooledObjectFactory.clearClassLoader(loader);
    }
}

