/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.ByteBufferPool;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ByteBufferUtil {
    private static boolean streamHasByteBufferRead(InputStream stream) {
        if (!(stream instanceof ByteBufferReadable)) {
            return false;
        }
        if (!(stream instanceof FSDataInputStream)) {
            return true;
        }
        return ((FSDataInputStream)stream).getWrappedStream() instanceof ByteBufferReadable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer fallbackRead(InputStream stream, ByteBufferPool bufferPool, int maxLength) throws IOException {
        if (bufferPool == null) {
            throw new UnsupportedOperationException("zero-copy reads were not available, and you did not provide a fallback ByteBufferPool.");
        }
        boolean useDirect = ByteBufferUtil.streamHasByteBufferRead(stream);
        ByteBuffer buffer = bufferPool.getBuffer(useDirect, maxLength);
        if (buffer == null) {
            throw new UnsupportedOperationException("zero-copy reads were not available, and the ByteBufferPool did not provide us with " + (useDirect ? "a direct" : "an indirect") + "buffer.");
        }
        Preconditions.checkState(buffer.capacity() > 0);
        Preconditions.checkState(buffer.isDirect() == useDirect);
        maxLength = Math.min(maxLength, buffer.capacity());
        boolean success = false;
        try {
            if (useDirect) {
                buffer.clear();
                buffer.limit(maxLength);
                ByteBufferReadable readable = (ByteBufferReadable)((Object)stream);
                int totalRead = 0;
                while (true) {
                    if (totalRead >= maxLength) {
                        success = true;
                        break;
                    }
                    int nRead = readable.read(buffer);
                    if (nRead < 0) {
                        if (totalRead <= 0) break;
                        success = true;
                        break;
                    }
                    totalRead += nRead;
                }
                buffer.flip();
            } else {
                buffer.clear();
                int nRead = stream.read(buffer.array(), buffer.arrayOffset(), maxLength);
                if (nRead >= 0) {
                    buffer.limit(nRead);
                    success = true;
                }
            }
        }
        finally {
            if (!success) {
                bufferPool.putBuffer(buffer);
                buffer = null;
            }
        }
        return buffer;
    }
}

