/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Resource;
import java.util.Hashtable;

class ResourcePool {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int TRACE_INCREMENT_ = 100;
    private transient Hashtable resources_ = new Hashtable();
    private transient Hashtable referenceCounts_ = new Hashtable();
    public static final ResourcePool GLOBAL_RESOURCE_POOL = new ResourcePool();

    ResourcePool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            this.resources_.clear();
            this.referenceCounts_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        Object resourceKey = resource.getResourceKey();
        long referenceCount = -1L;
        boolean deregister = false;
        Hashtable hashtable = this.resources_;
        synchronized (hashtable) {
            if (this.resources_.containsKey(resourceKey)) {
                deregister = true;
                long[] lArray = (long[])this.referenceCounts_.get(resourceKey);
                lArray[0] = lArray[0] - 1L;
                referenceCount = lArray[0];
                if (referenceCount == 0L) {
                    int size;
                    this.resources_.remove(resourceKey);
                    this.referenceCounts_.remove(resourceKey);
                    if (Trace.isTraceOn() && (size = this.resources_.size()) % 100 == 0) {
                        Trace.log(3, "Resource pool " + this + " contains " + size + " resources.");
                    }
                }
            }
        }
    }

    public Resource getResource(Object resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException("resourceKey");
        }
        return (Resource)this.resources_.get(resourceKey);
    }

    public void register(Resource resource) {
        this.register(resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Resource resource, boolean replace) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        Object resourceKey = resource.getResourceKey();
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            if (this.resources_.containsKey(resourceKey)) {
                if (replace) {
                    this.resources_.put(resourceKey, resource);
                }
                long[] lArray = (long[])this.referenceCounts_.get(resourceKey);
                long l = lArray[0] + 1L;
                lArray[0] = l;
                long referenceCount = l;
            } else {
                int size;
                this.resources_.put(resourceKey, resource);
                this.referenceCounts_.put(resourceKey, new long[]{1L});
                long referenceCount = 1L;
                if (Trace.isTraceOn() && (size = this.resources_.size()) % 100 == 0) {
                    Trace.log(3, "Resource pool " + this + " contains " + size + " resources.");
                }
            }
        }
    }
}

