/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

class PcmlStruct
extends PcmlDocNode {
    static final long serialVersionUID = 5539999574454926624L;
    private static final String[] STRUCTATTRIBUTES = new String[]{"name", "usage", "count", "minvrm", "maxvrm", "offset", "offsetfrom", "outputsize"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 8;
    private int m_Count;
    private String m_CountId;
    private int m_Offset;
    private String m_OffsetId;
    private boolean m_OffsetfromFixed;
    private int m_Offsetfrom;
    private String m_OffsetfromId;
    private String m_Minvrm;
    private int m_MinvrmInt;
    private String m_Maxvrm;
    private int m_MaxvrmInt;
    private int m_Outputsize;
    private String m_OutputsizeId;

    PcmlStruct() {
    }

    public PcmlStruct(PcmlAttributeList attrs) {
        super(attrs);
        this.setNodeType(3);
        this.setCount(this.getAttributeValue("count"));
        this.setOffset(this.getAttributeValue("offset"));
        this.setOffsetfrom(this.getAttributeValue("offsetfrom"));
        this.setOutputsize(this.getAttributeValue("outputsize"));
        this.setMinvrm(this.getAttributeValue("minvrm"));
        this.setMaxvrm(this.getAttributeValue("maxvrm"));
    }

    @Override
    String[] getAttributeList() {
        return STRUCTATTRIBUTES;
    }

    int getCount(PcmlDimensions indices) throws PcmlException {
        return this.resolveIntegerValue(this.getCount(), this.getCountId(), indices);
    }

    final int getXPCMLCount(PcmlDimensions indices) throws PcmlException {
        try {
            int rc = this.resolveIntegerValue(this.getCount(), this.getCountId(), indices);
            return rc;
        }
        catch (Exception e) {
            return 0;
        }
    }

    PcmlDimensions getDimensions(PcmlDimensions indices) throws PcmlException {
        PcmlDimensions myDimensions = null;
        PcmlNode node = this.getParent();
        myDimensions = node instanceof PcmlData ? ((PcmlData)node).getDimensions(indices) : (node instanceof PcmlStruct ? ((PcmlStruct)node).getDimensions(indices) : new PcmlDimensions(this.getNbrOfDimensions()));
        if (this.isArray()) {
            int myCount = this.getCount(indices);
            myDimensions.add(myCount);
        }
        return myDimensions;
    }

    long[] getDimensionTimestamps(PcmlDimensions indices) throws PcmlException {
        long[] myTimestamps;
        Integer myIndex = null;
        PcmlNode node = this.getParent();
        if (this.isArray()) {
            myIndex = indices.integerAt(indices.size() - 1);
            indices.remove();
        }
        long[] previousTimestamps = node instanceof PcmlData ? ((PcmlData)node).getDimensionTimestamps(indices) : (node instanceof PcmlStruct ? ((PcmlStruct)node).getDimensionTimestamps(indices) : new long[]{});
        if (myIndex != null) {
            int i;
            indices.add(myIndex);
            myTimestamps = new long[previousTimestamps.length + 1];
            for (i = 0; i < previousTimestamps.length; ++i) {
                myTimestamps[i] = previousTimestamps[i];
            }
            myTimestamps[i] = this.resolveDimensionTimestamp(indices);
            if (i > 0) {
                myTimestamps[i] = Math.max(myTimestamps[i], myTimestamps[i - 1]);
            }
        } else {
            myTimestamps = previousTimestamps;
        }
        return myTimestamps;
    }

    int getNbrOfDimensions() {
        int total = 0;
        PcmlNode node = this.getParent();
        if (this.isArray()) {
            ++total;
        }
        if (node instanceof PcmlData) {
            total += ((PcmlData)node).getNbrOfDimensions();
        } else if (node instanceof PcmlStruct) {
            total += ((PcmlStruct)node).getNbrOfDimensions();
        }
        return total;
    }

    int getOffset(PcmlDimensions indices) throws PcmlException {
        return this.resolveIntegerValue(this.getOffset(), this.getOffsetId(), indices);
    }

    public final int getOffset() {
        return this.m_Offset;
    }

    public final String getOffsetId() {
        return this.resolveRelativeName(this.m_OffsetId);
    }

    public final String getUnqualifiedOffsetId() {
        return this.m_OffsetId;
    }

    private final boolean isOffsetfromFixed() {
        return this.m_OffsetfromFixed;
    }

    final int getOffsetfrom() {
        if (this.isOffsetfromFixed()) {
            return this.m_Offsetfrom;
        }
        return -1;
    }

    final String getOffsetfromId() {
        return this.resolveRelativeName(this.m_OffsetfromId);
    }

    public final String getUnqualifiedOffsetfromId() {
        return this.m_OffsetfromId;
    }

    int getOutputsize(PcmlDimensions indices) throws PcmlException {
        boolean processArray;
        int myCount;
        int totalSize = 0;
        totalSize = this.resolveIntegerValue(this.getOutputsize(), this.getOutputsizeId(), indices);
        if (totalSize > 0) {
            return totalSize;
        }
        if (this.isArray() && indices.size() < this.getNbrOfDimensions()) {
            myCount = this.getCount(indices);
            processArray = true;
        } else {
            myCount = 1;
            processArray = false;
        }
        for (int myIndex = 0; myIndex < myCount; ++myIndex) {
            if (processArray) {
                indices.add(myIndex);
            }
            Enumeration children = this.getChildren();
            block5: while (children.hasMoreElements()) {
                PcmlDocNode child = (PcmlDocNode)children.nextElement();
                switch (child.getNodeType()) {
                    case 3: {
                        totalSize += ((PcmlStruct)child).getOutputsize(indices);
                        continue block5;
                    }
                    case 4: {
                        totalSize += ((PcmlData)child).getOutputsize(indices);
                        continue block5;
                    }
                }
                throw new PcmlException("BAD_NODE_TYPE", new Object[]{child.getNodeType(), this.getNameForException()});
            }
            if (!processArray) continue;
            indices.remove();
        }
        return totalSize;
    }

    boolean isArray() {
        if (this.getCount() > 0) {
            return true;
        }
        return this.getCountId() != null;
    }

    boolean isInArray() {
        PcmlNode node = this.getParent();
        if (this.isArray()) {
            return true;
        }
        if (node instanceof PcmlData) {
            return ((PcmlData)node).isArray();
        }
        if (node instanceof PcmlStruct) {
            return ((PcmlStruct)node).isArray();
        }
        return false;
    }

    public int getCount() {
        return this.m_Count;
    }

    public String getCountId() {
        return this.resolveRelativeName(this.m_CountId);
    }

    public final String getUnqualifiedCountId() {
        return this.m_CountId;
    }

    public final int getMaxvrm() {
        return this.m_MaxvrmInt;
    }

    public final String getMaxvrmString() {
        return this.m_Maxvrm;
    }

    public final int getMinvrm() {
        return this.m_MinvrmInt;
    }

    public final String getMinvrmString() {
        return this.m_Minvrm;
    }

    public final int getOutputsize() {
        return this.m_Outputsize;
    }

    public final String getOutputsizeId() {
        return this.resolveRelativeName(this.m_OutputsizeId);
    }

    public final String getUnqualifiedOutputsizeId() {
        return this.m_OutputsizeId;
    }

    private void setCount(String count) {
        if (count == null || count.equals("")) {
            this.m_Count = 0;
            this.m_CountId = null;
            return;
        }
        try {
            this.m_Count = Integer.parseInt(count);
            this.m_CountId = null;
        }
        catch (NumberFormatException e) {
            this.m_Count = 0;
            this.m_CountId = count;
        }
    }

    private void setMaxvrm(String maxvrm) {
        this.m_MaxvrmInt = Integer.MAX_VALUE;
        if (maxvrm == null || maxvrm.equals("")) {
            this.m_Maxvrm = null;
            return;
        }
        this.m_Maxvrm = maxvrm;
    }

    private void setMinvrm(String minvrm) {
        this.m_MinvrmInt = Integer.MIN_VALUE;
        if (minvrm == null || minvrm.equals("")) {
            this.m_Minvrm = null;
            return;
        }
        this.m_Minvrm = minvrm;
    }

    private void setOffset(String offset) {
        if (offset == null || offset.equals("")) {
            this.m_Offset = 0;
            this.m_OffsetId = null;
            return;
        }
        try {
            this.m_Offset = Integer.parseInt(offset);
            this.m_OffsetId = null;
        }
        catch (NumberFormatException e) {
            this.m_Offset = 0;
            this.m_OffsetId = offset;
        }
    }

    private void setOffsetfrom(String offsetfrom) {
        this.m_OffsetfromFixed = true;
        if (offsetfrom == null || offsetfrom.equals("")) {
            this.m_Offsetfrom = -1;
            this.m_OffsetfromId = null;
            return;
        }
        try {
            this.m_Offsetfrom = Integer.parseInt(offsetfrom);
            this.m_OffsetfromId = null;
        }
        catch (NumberFormatException e) {
            this.m_Offsetfrom = 0;
            this.m_OffsetfromId = offsetfrom;
        }
    }

    private void setOutputsize(String outputsize) {
        if (outputsize == null || outputsize.equals("")) {
            this.m_Outputsize = 0;
            return;
        }
        try {
            this.m_Outputsize = Integer.parseInt(outputsize);
            this.m_OutputsizeId = null;
        }
        catch (NumberFormatException e) {
            this.m_Outputsize = 0;
            this.m_OutputsizeId = outputsize;
        }
    }

    @Override
    protected void checkAttributes() {
        PcmlDocNode resolvedNode;
        super.checkAttributes();
        if (this.m_CountId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_CountId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlStruct.makeQuotedAttr("count", this.m_CountId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlStruct.makeQuotedAttr("count", this.m_CountId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlStruct.makeQuotedAttr("count", this.m_CountId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Count < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlStruct.makeQuotedAttr("count", this.m_Count), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OffsetId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_OffsetId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlStruct.makeQuotedAttr("offset", this.m_OffsetId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlStruct.makeQuotedAttr("offset", this.m_OffsetId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlStruct.makeQuotedAttr("offset", this.m_OffsetId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Offset < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlStruct.makeQuotedAttr("offset", this.m_Offset), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OffsetfromId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_OffsetfromId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlStruct.makeQuotedAttr("offsetfrom", this.m_OffsetfromId), this.getNameForException()});
            } else {
                String qNameResolved;
                String qName = this.getQualifiedName();
                if (qName.equals("")) {
                    qName = this.getNameForException();
                }
                if (!qName.startsWith((qNameResolved = resolvedNode.getQualifiedName()) + ".")) {
                    this.getDoc().addPcmlSpecificationError("OFFSETFROM_NOT_FOUND", new Object[]{this.m_OffsetfromId, this.getNameForException()});
                }
            }
        } else if (this.m_Offsetfrom < -1) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlStruct.makeQuotedAttr("offsetfrom", this.m_Offsetfrom), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_Minvrm != null) {
            this.m_MinvrmInt = PcmlData.validateVRM(this.m_Minvrm);
            if (this.m_MinvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlStruct.makeQuotedAttr("minvrm", this.m_Minvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_Maxvrm != null) {
            this.m_MaxvrmInt = PcmlData.validateVRM(this.m_Maxvrm);
            if (this.m_MaxvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlStruct.makeQuotedAttr("maxvrm", this.m_Maxvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_OutputsizeId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_OutputsizeId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlStruct.makeQuotedAttr("outputsize", this.m_OutputsizeId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlStruct.makeQuotedAttr("outputsize", this.m_OutputsizeId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlStruct.makeQuotedAttr("outputsize", this.m_OutputsizeId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Outputsize < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlStruct.makeQuotedAttr("outputsize", this.m_Outputsize), this.getBracketedTagName(), this.getNameForException()});
        }
    }

    boolean isSupportedAtHostVRM() throws PcmlException {
        int hostVrm = this.getAs400VRM();
        if (this.getMinvrm() > hostVrm) {
            return false;
        }
        return this.getMaxvrm() >= hostVrm;
    }

    int toBytes(OutputStream bytes, int offset, PcmlDimensions indices) throws PcmlException {
        boolean processArray;
        int myCount;
        int totalBytes = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && indices.size() < this.getNbrOfDimensions()) {
            myCount = this.getCount(indices);
            processArray = true;
        } else {
            myCount = 1;
            processArray = false;
        }
        for (int myIndex = 0; myIndex < myCount; ++myIndex) {
            if (processArray) {
                indices.add(myIndex);
            }
            Enumeration children = this.getChildren();
            block5: while (children.hasMoreElements()) {
                PcmlDocNode child = (PcmlDocNode)children.nextElement();
                switch (child.getNodeType()) {
                    case 3: {
                        totalBytes += ((PcmlStruct)child).toBytes(bytes, offset + totalBytes, indices);
                        continue block5;
                    }
                    case 4: {
                        totalBytes += ((PcmlData)child).toBytes(bytes, offset + totalBytes, indices);
                        continue block5;
                    }
                }
                throw new PcmlException("BAD_NODE_TYPE", new Object[]{child.getNodeType(), this.getNameForException()});
            }
            if (!processArray) continue;
            indices.remove();
        }
        return totalBytes;
    }

    int parseBytes(byte[] bytes, int offset, Hashtable offsetStack, PcmlDimensions indices) throws PcmlException {
        boolean processArray;
        int myCount;
        int nbrBytes = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && indices.size() < this.getNbrOfDimensions()) {
            myCount = this.getCount(indices);
            processArray = true;
        } else {
            myCount = 1;
            processArray = false;
        }
        int skipBytes = 0;
        int myOffset = this.getOffset(indices);
        if (myOffset > 0) {
            Integer myOffsetbase = null;
            String myOffsetfromId = this.getOffsetfromId();
            if (myOffsetfromId != null) {
                myOffsetbase = (Integer)offsetStack.get(myOffsetfromId);
                if (myOffsetbase == null) {
                    throw new PcmlException("OFFSETFROM_NOT_FOUND", new Object[]{myOffsetfromId, this.getNameForException()});
                }
            } else {
                myOffsetbase = this.getOffsetfrom() >= 0 ? Integer.valueOf(this.getOffsetfrom()) : (Integer)offsetStack.get(((PcmlDocNode)this.getParent()).getQualifiedName());
            }
            if (myOffsetbase != null) {
                myOffset += myOffsetbase.intValue();
            }
            if (myOffset > offset) {
                skipBytes = myOffset - offset;
            }
        }
        for (int myIndex = 0; myIndex < myCount; ++myIndex) {
            String qName = this.getQualifiedName();
            if (!qName.equals("")) {
                offsetStack.put(qName, offset + skipBytes + nbrBytes);
            }
            if (processArray) {
                indices.add(myIndex);
            }
            Enumeration children = this.getChildren();
            block5: while (children.hasMoreElements()) {
                PcmlDocNode child = (PcmlDocNode)children.nextElement();
                switch (child.getNodeType()) {
                    case 3: {
                        PcmlStruct structNode = (PcmlStruct)child;
                        nbrBytes += structNode.parseBytes(bytes, offset + skipBytes + nbrBytes, offsetStack, indices);
                        continue block5;
                    }
                    case 4: {
                        PcmlData dataNode = (PcmlData)child;
                        nbrBytes += dataNode.parseBytes(bytes, offset + skipBytes + nbrBytes, offsetStack, indices);
                        continue block5;
                    }
                }
                throw new PcmlException("BAD_NODE_TYPE", new Object[]{child.getNodeType(), this.getNameForException()});
            }
            if (processArray) {
                indices.remove();
            }
            if (qName.equals("")) continue;
            offsetStack.remove(qName);
        }
        return nbrBytes + skipBytes;
    }

    private int resolveIntegerValue(int intLiteral, String name, PcmlDimensions indices) throws PcmlException {
        if (name != null) {
            PcmlNode node = this.getDoc().getElement(name);
            if (node instanceof PcmlData) {
                PcmlData dataNode = (PcmlData)node;
                Object nodeValue = dataNode.getValue(indices);
                if (nodeValue instanceof String) {
                    return Integer.parseInt((String)nodeValue);
                }
                if (nodeValue instanceof Number) {
                    return ((Number)nodeValue).intValue();
                }
                if (nodeValue == null) {
                    throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{dataNode.getNameForException()});
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{nodeValue.getClass().getName(), dataNode.getNameForException()});
            }
            if (node == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{name, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{name, "<data>"});
        }
        return intLiteral;
    }

    private long resolveDimensionTimestamp(PcmlDimensions indices) throws PcmlException {
        String name = this.getCountId();
        if (name != null) {
            PcmlNode node = this.getDoc().getElement(name);
            if (node instanceof PcmlData) {
                return ((PcmlData)node).getTimestamp(indices);
            }
            if (node == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{name, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{name, "<data>"});
        }
        return Long.MIN_VALUE;
    }
}

