/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.snowflake;

import java.sql.ResultSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.snowflake.WarehouseManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WarehouseManagerDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = WarehouseManager.class;
    private static final String[] MANAGEMENT_ACTION_DESCS = new String[]{BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Action.Create", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Action.Drop", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Action.Resume", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Action.Suspend", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Action.Alter", (String[])new String[0])};
    private static final String[] WAREHOUSE_SIZE_DESCS = new String[]{BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Size.Xsmall", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Size.Small", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Size.Medium", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Size.Large", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Size.Xlarge", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Size.Xxlarge", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Size.Xxxlarge", (String[])new String[0])};
    private static final String[] WAREHOUSE_TYPE_DESCS = new String[]{BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Type.Standard", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Type.Enterprise", (String[])new String[0])};
    private WarehouseManager warehouseManager;
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private ComboVar wWarehouseName;
    private CCombo wAction;
    private Group wCreateGroup;
    private Button wCreateReplace;
    private Button wCreateFailIfExists;
    private ComboVar wCreateWarehouseSize;
    private ComboVar wCreateWarehouseType;
    private TextVar wCreateMaxClusterSize;
    private TextVar wCreateMinClusterSize;
    private TextVar wCreateAutoSuspend;
    private Button wCreateAutoResume;
    private Button wCreateInitialSuspend;
    private ComboVar wCreateResourceMonitor;
    private TextVar wCreateComment;
    private Group wDropGroup;
    private Button wDropFailIfNotExists;
    private Group wResumeGroup;
    private Button wResumeFailIfNotExists;
    private Group wSuspendGroup;
    private Button wSuspendFailIfNotExists;
    private Group wAlterGroup;
    private Button wAlterFailIfNotExists;
    private ComboVar wAlterWarehouseSize;
    private ComboVar wAlterWarehouseType;
    private TextVar wAlterMaxClusterSize;
    private TextVar wAlterMinClusterSize;
    private TextVar wAlterAutoSuspend;
    private Button wAlterAutoResume;
    private ComboVar wAlterResourceMonitor;
    private TextVar wAlterComment;
    private boolean backupChanged;
    private Shell shell;

    public WarehouseManagerDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.warehouseManager = (WarehouseManager)action;
    }

    public IAction open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.warehouseManager);
        this.backupChanged = this.warehouseManager.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.top = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, this.warehouseManager.getDatabaseMeta(), null);
        if (this.warehouseManager.getDatabaseMeta() == null && this.workflowMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        Label wlWarehouseName = new Label((Composite)this.shell, 131072);
        wlWarehouseName.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.WarehouseName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWarehouseName);
        FormData fdlWarehouseName = new FormData();
        fdlWarehouseName.left = new FormAttachment(0, 0);
        fdlWarehouseName.top = new FormAttachment(this.wConnection, margin * 2);
        fdlWarehouseName.right = new FormAttachment(middle, -margin);
        wlWarehouseName.setLayoutData((Object)fdlWarehouseName);
        this.wWarehouseName = new ComboVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wWarehouseName);
        FormData fdWarehouseName = new FormData();
        fdWarehouseName.left = new FormAttachment(middle, 0);
        fdWarehouseName.top = new FormAttachment(this.wConnection, margin * 2);
        fdWarehouseName.right = new FormAttachment(100, 0);
        this.wWarehouseName.setLayoutData((Object)fdWarehouseName);
        this.wWarehouseName.addFocusListener((FocusListener)new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusGained(FocusEvent focusEvent) {
                DatabaseMeta databaseMeta = WarehouseManagerDialog.this.workflowMeta.findDatabase(WarehouseManagerDialog.this.wConnection.getText(), WarehouseManagerDialog.this.variables);
                if (databaseMeta != null) {
                    String warehouseName = WarehouseManagerDialog.this.wWarehouseName.getText();
                    WarehouseManagerDialog.this.wWarehouseName.removeAll();
                    Database db = null;
                    try {
                        db = new Database(ActionDialog.loggingObject, WarehouseManagerDialog.this.variables, databaseMeta);
                        db.connect();
                        try (ResultSet resultSet = db.openQuery("show warehouses;", null, null, 1000, false);){
                            IRowMeta rowMeta = db.getReturnRowMeta();
                            Object[] row = db.getRow(resultSet);
                            int nameField = rowMeta.indexOfValue("NAME");
                            if (nameField >= 0) {
                                while (row != null) {
                                    String name = rowMeta.getString(row, nameField);
                                    WarehouseManagerDialog.this.wWarehouseName.add(name);
                                    row = db.getRow(resultSet);
                                }
                            } else {
                                throw new HopException("Unable to find warehouse name field in result");
                            }
                            db.closeQuery(resultSet);
                        }
                        if (warehouseName != null) {
                            WarehouseManagerDialog.this.wWarehouseName.setText(warehouseName);
                        }
                    }
                    catch (Exception ex) {
                        WarehouseManagerDialog.this.warehouseManager.logDebug("Error getting warehouses", new Object[]{ex});
                    }
                    finally {
                        if (db != null) {
                            db.disconnect();
                        }
                    }
                }
            }
        });
        Label wlAction = new Label((Composite)this.shell, 131072);
        wlAction.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Action.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAction);
        FormData fdlAction = new FormData();
        fdlAction.left = new FormAttachment(0, 0);
        fdlAction.right = new FormAttachment(middle, -margin);
        fdlAction.top = new FormAttachment((Control)this.wWarehouseName, margin);
        wlAction.setLayoutData((Object)fdlAction);
        this.wAction = new CCombo((Composite)this.shell, 2060);
        this.wAction.setItems(MANAGEMENT_ACTION_DESCS);
        PropsUi.setLook((Widget)this.wAction);
        FormData fdAction = new FormData();
        fdAction.left = new FormAttachment(middle, 0);
        fdAction.top = new FormAttachment((Control)this.wWarehouseName, margin);
        fdAction.right = new FormAttachment(100, 0);
        this.wAction.setLayoutData((Object)fdAction);
        this.wAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WarehouseManagerDialog.this.setFlags();
            }
        });
        this.wCreateGroup = new Group((Composite)this.shell, 16);
        this.wCreateGroup.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Group.CreateWarehouse.Label", (String[])new String[0]));
        FormLayout createWarehouseLayout = new FormLayout();
        createWarehouseLayout.marginWidth = 3;
        createWarehouseLayout.marginHeight = 3;
        this.wCreateGroup.setLayout((Layout)createWarehouseLayout);
        PropsUi.setLook((Widget)this.wCreateGroup);
        FormData fdgCreateGroup = new FormData();
        fdgCreateGroup.left = new FormAttachment(0, 0);
        fdgCreateGroup.right = new FormAttachment(100, 0);
        fdgCreateGroup.top = new FormAttachment((Control)this.wAction, margin * 2);
        this.wCreateGroup.setLayoutData((Object)fdgCreateGroup);
        Label wlCreateReplace = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateReplace.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.Replace.Label", (String[])new String[0]));
        wlCreateReplace.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.Replace.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateReplace);
        FormData fdlCreateReplace = new FormData();
        fdlCreateReplace.left = new FormAttachment(0, 0);
        fdlCreateReplace.top = new FormAttachment(0, margin * 2);
        fdlCreateReplace.right = new FormAttachment(middle, -margin);
        wlCreateReplace.setLayoutData((Object)fdlCreateReplace);
        this.wCreateReplace = new Button((Composite)this.wCreateGroup, 32);
        PropsUi.setLook((Widget)this.wCreateReplace);
        FormData fdCreateReplace = new FormData();
        fdCreateReplace.left = new FormAttachment(middle, 0);
        fdCreateReplace.top = new FormAttachment(0, margin * 2);
        fdCreateReplace.right = new FormAttachment(100, 0);
        this.wCreateReplace.setLayoutData((Object)fdCreateReplace);
        this.wCreateReplace.addListener(13, e -> this.warehouseManager.setChanged());
        this.wCreateReplace.addListener(13, e -> this.setFlags());
        Label wlCreateFailIfExists = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateFailIfExists.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.FailIfExists.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateFailIfExists);
        FormData fdlCreateFailIfExists = new FormData();
        fdlCreateFailIfExists.left = new FormAttachment(0, 0);
        fdlCreateFailIfExists.top = new FormAttachment((Control)this.wCreateReplace, margin * 2);
        fdlCreateFailIfExists.right = new FormAttachment(middle, -margin);
        wlCreateFailIfExists.setLayoutData((Object)fdlCreateFailIfExists);
        this.wCreateFailIfExists = new Button((Composite)this.wCreateGroup, 32);
        PropsUi.setLook((Widget)this.wCreateFailIfExists);
        FormData fdCreateFailIfExists = new FormData();
        fdCreateFailIfExists.left = new FormAttachment(middle, 0);
        fdCreateFailIfExists.top = new FormAttachment((Control)this.wCreateReplace, margin * 2);
        fdCreateFailIfExists.right = new FormAttachment(100, 0);
        this.wCreateFailIfExists.setLayoutData((Object)fdCreateFailIfExists);
        this.wCreateFailIfExists.addListener(13, e -> this.warehouseManager.setChanged());
        Label wlCreateWarehouseSize = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateWarehouseSize.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.CreateWarehouseSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateWarehouseSize);
        FormData fdlCreateWarehouseSize = new FormData();
        fdlCreateWarehouseSize.left = new FormAttachment(0, 0);
        fdlCreateWarehouseSize.top = new FormAttachment((Control)this.wCreateFailIfExists, margin * 2);
        fdlCreateWarehouseSize.right = new FormAttachment(middle, -margin);
        wlCreateWarehouseSize.setLayoutData((Object)fdlCreateWarehouseSize);
        this.wCreateWarehouseSize = new ComboVar(this.variables, (Composite)this.wCreateGroup, 18436);
        PropsUi.setLook((Widget)this.wCreateWarehouseSize);
        this.wCreateWarehouseSize.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdCreateWarehouseSize = new FormData();
        fdCreateWarehouseSize.left = new FormAttachment(middle, 0);
        fdCreateWarehouseSize.top = new FormAttachment((Control)this.wCreateFailIfExists, margin * 2);
        fdCreateWarehouseSize.right = new FormAttachment(100, 0);
        this.wCreateWarehouseSize.setLayoutData((Object)fdCreateWarehouseSize);
        this.wCreateWarehouseSize.setItems(WAREHOUSE_SIZE_DESCS);
        Label wlCreateWarehouseType = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateWarehouseType.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.CreateWarehouseType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateWarehouseType);
        FormData fdlCreateWarehouseType = new FormData();
        fdlCreateWarehouseType.left = new FormAttachment(0, 0);
        fdlCreateWarehouseType.top = new FormAttachment((Control)this.wCreateWarehouseSize, margin * 2);
        fdlCreateWarehouseType.right = new FormAttachment(middle, -margin);
        wlCreateWarehouseType.setLayoutData((Object)fdlCreateWarehouseType);
        this.wCreateWarehouseType = new ComboVar(this.variables, (Composite)this.wCreateGroup, 18436);
        PropsUi.setLook((Widget)this.wCreateWarehouseType);
        this.wCreateWarehouseType.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdCreateWarehouseType = new FormData();
        fdCreateWarehouseType.left = new FormAttachment(middle, 0);
        fdCreateWarehouseType.top = new FormAttachment((Control)this.wCreateWarehouseSize, margin * 2);
        fdCreateWarehouseType.right = new FormAttachment(100, 0);
        this.wCreateWarehouseType.setLayoutData((Object)fdCreateWarehouseType);
        this.wCreateWarehouseType.setItems(WAREHOUSE_TYPE_DESCS);
        Label wlCreateMaxClusterSize = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateMaxClusterSize.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.MaxClusterSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateMaxClusterSize);
        FormData fdlCreateMaxClusterSize = new FormData();
        fdlCreateMaxClusterSize.left = new FormAttachment(0, 0);
        fdlCreateMaxClusterSize.top = new FormAttachment((Control)this.wCreateWarehouseType, margin * 2);
        fdlCreateMaxClusterSize.right = new FormAttachment(middle, -margin);
        wlCreateMaxClusterSize.setLayoutData((Object)fdlCreateMaxClusterSize);
        this.wCreateMaxClusterSize = new TextVar(this.variables, (Composite)this.wCreateGroup, 18436);
        PropsUi.setLook((Widget)this.wCreateGroup);
        this.wCreateMaxClusterSize.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdCreateMaxClusterSize = new FormData();
        fdCreateMaxClusterSize.left = new FormAttachment(middle, 0);
        fdCreateMaxClusterSize.right = new FormAttachment(100, 0);
        fdCreateMaxClusterSize.top = new FormAttachment((Control)this.wCreateWarehouseType, margin * 2);
        this.wCreateMaxClusterSize.setLayoutData((Object)fdCreateMaxClusterSize);
        Label wlCreateMinClusterSize = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateMinClusterSize.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.MinClusterSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateMinClusterSize);
        FormData fdlCreateMinClusterSize = new FormData();
        fdlCreateMinClusterSize.left = new FormAttachment(0, 0);
        fdlCreateMinClusterSize.top = new FormAttachment((Control)this.wCreateMaxClusterSize, margin * 2);
        fdlCreateMinClusterSize.right = new FormAttachment(middle, -margin);
        wlCreateMinClusterSize.setLayoutData((Object)fdlCreateMinClusterSize);
        this.wCreateMinClusterSize = new TextVar(this.variables, (Composite)this.wCreateGroup, 18436);
        PropsUi.setLook((Widget)this.wCreateGroup);
        this.wCreateMinClusterSize.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdCreateMinClusterSize = new FormData();
        fdCreateMinClusterSize.left = new FormAttachment(middle, 0);
        fdCreateMinClusterSize.right = new FormAttachment(100, 0);
        fdCreateMinClusterSize.top = new FormAttachment((Control)this.wCreateMaxClusterSize, margin * 2);
        this.wCreateMinClusterSize.setLayoutData((Object)fdCreateMinClusterSize);
        Label wlCreateAutoSuspend = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateAutoSuspend.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.AutoSuspend.Label", (String[])new String[0]));
        wlCreateAutoSuspend.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.AutoSuspend.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateAutoSuspend);
        FormData fdlCreateAutoSuspend = new FormData();
        fdlCreateAutoSuspend.left = new FormAttachment(0, 0);
        fdlCreateAutoSuspend.top = new FormAttachment((Control)this.wCreateMinClusterSize, margin * 2);
        fdlCreateAutoSuspend.right = new FormAttachment(middle, -margin);
        wlCreateAutoSuspend.setLayoutData((Object)fdlCreateAutoSuspend);
        this.wCreateAutoSuspend = new TextVar(this.variables, (Composite)this.wCreateGroup, 18436);
        PropsUi.setLook((Widget)this.wCreateGroup);
        this.wCreateAutoSuspend.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdCreateAutoSuspend = new FormData();
        fdCreateAutoSuspend.left = new FormAttachment(middle, 0);
        fdCreateAutoSuspend.right = new FormAttachment(100, 0);
        fdCreateAutoSuspend.top = new FormAttachment((Control)this.wCreateMinClusterSize, margin * 2);
        this.wCreateAutoSuspend.setLayoutData((Object)fdCreateAutoSuspend);
        Label wlCreateAutoResume = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateAutoResume.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.AutoResume.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateAutoResume);
        FormData fdlCreateAutoResume = new FormData();
        fdlCreateAutoResume.left = new FormAttachment(0, 0);
        fdlCreateAutoResume.top = new FormAttachment((Control)this.wCreateAutoSuspend, margin * 2);
        fdlCreateAutoResume.right = new FormAttachment(middle, -margin);
        wlCreateAutoResume.setLayoutData((Object)fdlCreateAutoResume);
        this.wCreateAutoResume = new Button((Composite)this.wCreateGroup, 32);
        PropsUi.setLook((Widget)this.wCreateAutoResume);
        FormData fdCreateAutoResume = new FormData();
        fdCreateAutoResume.left = new FormAttachment(middle, 0);
        fdCreateAutoResume.top = new FormAttachment((Control)this.wCreateAutoSuspend, margin * 2);
        fdCreateAutoResume.right = new FormAttachment(100, 0);
        this.wCreateAutoResume.setLayoutData((Object)fdCreateAutoResume);
        this.wCreateAutoResume.addListener(13, e -> this.warehouseManager.setChanged());
        Label wlCreateInitialSuspend = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateInitialSuspend.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.InitialSuspend.Label", (String[])new String[0]));
        wlCreateInitialSuspend.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.InitialSuspend.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateInitialSuspend);
        FormData fdlCreateInitialSuspend = new FormData();
        fdlCreateInitialSuspend.left = new FormAttachment(0, 0);
        fdlCreateInitialSuspend.top = new FormAttachment((Control)this.wCreateAutoResume, margin * 2);
        fdlCreateInitialSuspend.right = new FormAttachment(middle, -margin);
        wlCreateInitialSuspend.setLayoutData((Object)fdlCreateInitialSuspend);
        this.wCreateInitialSuspend = new Button((Composite)this.wCreateGroup, 32);
        PropsUi.setLook((Widget)this.wCreateInitialSuspend);
        FormData fdCreateInitialSuspend = new FormData();
        fdCreateInitialSuspend.left = new FormAttachment(middle, 0);
        fdCreateInitialSuspend.top = new FormAttachment((Control)this.wCreateAutoResume, margin * 2);
        fdCreateInitialSuspend.right = new FormAttachment(100, 0);
        this.wCreateInitialSuspend.setLayoutData((Object)fdCreateInitialSuspend);
        this.wCreateInitialSuspend.addListener(13, e -> this.warehouseManager.setChanged());
        Label wlCreateResourceMonitor = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateResourceMonitor.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.ResourceMonitor.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateResourceMonitor);
        FormData fdlCreateResourceMonitor = new FormData();
        fdlCreateResourceMonitor.left = new FormAttachment(0, 0);
        fdlCreateResourceMonitor.top = new FormAttachment((Control)this.wCreateInitialSuspend, margin * 2);
        fdlCreateResourceMonitor.right = new FormAttachment(middle, -margin);
        wlCreateResourceMonitor.setLayoutData((Object)fdlCreateResourceMonitor);
        this.wCreateResourceMonitor = new ComboVar(this.variables, (Composite)this.wCreateGroup, 18436);
        PropsUi.setLook((Widget)this.wCreateResourceMonitor);
        this.wCreateResourceMonitor.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdCreateResourceMonitor = new FormData();
        fdCreateResourceMonitor.left = new FormAttachment(middle, 0);
        fdCreateResourceMonitor.top = new FormAttachment((Control)this.wCreateInitialSuspend, margin * 2);
        fdCreateResourceMonitor.right = new FormAttachment(100, 0);
        this.wCreateResourceMonitor.setLayoutData((Object)fdCreateResourceMonitor);
        this.wCreateResourceMonitor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WarehouseManagerDialog.this.getResourceMonitors();
            }
        });
        Label wlCreateComment = new Label((Composite)this.wCreateGroup, 131072);
        wlCreateComment.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Create.Comment.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateComment);
        FormData fdlCreateComment = new FormData();
        fdlCreateComment.left = new FormAttachment(0, 0);
        fdlCreateComment.top = new FormAttachment((Control)this.wCreateResourceMonitor, margin * 2);
        fdlCreateComment.right = new FormAttachment(middle, -margin);
        wlCreateComment.setLayoutData((Object)fdlCreateComment);
        this.wCreateComment = new TextVar(this.variables, (Composite)this.wCreateGroup, 18436);
        PropsUi.setLook((Widget)this.wCreateGroup);
        this.wCreateComment.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdCreateComment = new FormData();
        fdCreateComment.left = new FormAttachment(middle, 0);
        fdCreateComment.right = new FormAttachment(100, 0);
        fdCreateComment.top = new FormAttachment((Control)this.wCreateResourceMonitor, margin * 2);
        this.wCreateComment.setLayoutData((Object)fdCreateComment);
        this.wDropGroup = new Group((Composite)this.shell, 16);
        this.wDropGroup.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Group.DropWarehouse.Label", (String[])new String[0]));
        FormLayout dropWarehouseLayout = new FormLayout();
        dropWarehouseLayout.marginWidth = 3;
        dropWarehouseLayout.marginHeight = 3;
        this.wDropGroup.setLayout((Layout)dropWarehouseLayout);
        PropsUi.setLook((Widget)this.wDropGroup);
        FormData fdgDropGroup = new FormData();
        fdgDropGroup.left = new FormAttachment(0, 0);
        fdgDropGroup.right = new FormAttachment(100, 0);
        fdgDropGroup.top = new FormAttachment((Control)this.wAction, margin * 2);
        this.wDropGroup.setLayoutData((Object)fdgDropGroup);
        Label wlDropFailIfNotExists = new Label((Composite)this.wDropGroup, 131072);
        wlDropFailIfNotExists.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Drop.FailIfNotExists.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDropFailIfNotExists);
        FormData fdlDropFailIfNotExists = new FormData();
        fdlDropFailIfNotExists.left = new FormAttachment(0, 0);
        fdlDropFailIfNotExists.top = new FormAttachment(0, margin);
        fdlDropFailIfNotExists.right = new FormAttachment(middle, -margin);
        wlDropFailIfNotExists.setLayoutData((Object)fdlDropFailIfNotExists);
        this.wDropFailIfNotExists = new Button((Composite)this.wDropGroup, 32);
        PropsUi.setLook((Widget)this.wDropFailIfNotExists);
        FormData fdDropFailIfNotExists = new FormData();
        fdDropFailIfNotExists.left = new FormAttachment(middle, 0);
        fdDropFailIfNotExists.top = new FormAttachment(0, margin);
        fdDropFailIfNotExists.right = new FormAttachment(100, 0);
        this.wDropFailIfNotExists.setLayoutData((Object)fdDropFailIfNotExists);
        this.wDropFailIfNotExists.addListener(13, e -> this.warehouseManager.setChanged());
        this.wResumeGroup = new Group((Composite)this.shell, 16);
        this.wResumeGroup.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Group.ResumeWarehouse.Label", (String[])new String[0]));
        FormLayout resumeWarehouseLayout = new FormLayout();
        resumeWarehouseLayout.marginWidth = 3;
        resumeWarehouseLayout.marginHeight = 3;
        this.wResumeGroup.setLayout((Layout)resumeWarehouseLayout);
        PropsUi.setLook((Widget)this.wResumeGroup);
        FormData fdgResumeGroup = new FormData();
        fdgResumeGroup.left = new FormAttachment(0, 0);
        fdgResumeGroup.right = new FormAttachment(100, 0);
        fdgResumeGroup.top = new FormAttachment((Control)this.wAction, margin * 2);
        this.wResumeGroup.setLayoutData((Object)fdgResumeGroup);
        Label wlResumeFailIfNotExists = new Label((Composite)this.wResumeGroup, 131072);
        wlResumeFailIfNotExists.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Resume.FailIfNotExists.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResumeFailIfNotExists);
        FormData fdlResumeFailIfNotExists = new FormData();
        fdlResumeFailIfNotExists.left = new FormAttachment(0, 0);
        fdlResumeFailIfNotExists.top = new FormAttachment(0, margin);
        fdlResumeFailIfNotExists.right = new FormAttachment(middle, -margin);
        wlResumeFailIfNotExists.setLayoutData((Object)fdlResumeFailIfNotExists);
        this.wResumeFailIfNotExists = new Button((Composite)this.wResumeGroup, 32);
        PropsUi.setLook((Widget)this.wResumeFailIfNotExists);
        FormData fdResumeFailIfNotExists = new FormData();
        fdResumeFailIfNotExists.left = new FormAttachment(middle, 0);
        fdResumeFailIfNotExists.top = new FormAttachment(0, margin);
        fdResumeFailIfNotExists.right = new FormAttachment(100, 0);
        this.wResumeFailIfNotExists.setLayoutData((Object)fdResumeFailIfNotExists);
        this.wResumeFailIfNotExists.addListener(13, e -> this.warehouseManager.setChanged());
        this.wSuspendGroup = new Group((Composite)this.shell, 16);
        this.wSuspendGroup.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Group.SuspendWarehouse.Label", (String[])new String[0]));
        FormLayout suspendWarehouseLayout = new FormLayout();
        suspendWarehouseLayout.marginWidth = 3;
        suspendWarehouseLayout.marginHeight = 3;
        this.wSuspendGroup.setLayout((Layout)suspendWarehouseLayout);
        PropsUi.setLook((Widget)this.wSuspendGroup);
        FormData fdgSuspendGroup = new FormData();
        fdgSuspendGroup.left = new FormAttachment(0, 0);
        fdgSuspendGroup.right = new FormAttachment(100, 0);
        fdgSuspendGroup.top = new FormAttachment((Control)this.wAction, margin * 2);
        this.wSuspendGroup.setLayoutData((Object)fdgSuspendGroup);
        Label wlSuspendFailIfNotExists = new Label((Composite)this.wSuspendGroup, 131072);
        wlSuspendFailIfNotExists.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Suspend.FailIfNotExists.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSuspendFailIfNotExists);
        FormData fdlSuspendFailIfNotExists = new FormData();
        fdlSuspendFailIfNotExists.left = new FormAttachment(0, 0);
        fdlSuspendFailIfNotExists.top = new FormAttachment(0, margin);
        fdlSuspendFailIfNotExists.right = new FormAttachment(middle, -margin);
        wlSuspendFailIfNotExists.setLayoutData((Object)fdlSuspendFailIfNotExists);
        this.wSuspendFailIfNotExists = new Button((Composite)this.wSuspendGroup, 32);
        PropsUi.setLook((Widget)this.wSuspendFailIfNotExists);
        FormData fdSuspendFailIfNotExists = new FormData();
        fdSuspendFailIfNotExists.left = new FormAttachment(middle, 0);
        fdSuspendFailIfNotExists.top = new FormAttachment(0, margin);
        fdSuspendFailIfNotExists.right = new FormAttachment(100, 0);
        this.wSuspendFailIfNotExists.setLayoutData((Object)fdSuspendFailIfNotExists);
        this.wSuspendFailIfNotExists.addListener(13, e -> this.warehouseManager.setChanged());
        this.wAlterGroup = new Group((Composite)this.shell, 16);
        this.wAlterGroup.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Group.AlterWarehouse.Label", (String[])new String[0]));
        FormLayout alterWarehouseLayout = new FormLayout();
        alterWarehouseLayout.marginWidth = 3;
        alterWarehouseLayout.marginHeight = 3;
        this.wAlterGroup.setLayout((Layout)alterWarehouseLayout);
        PropsUi.setLook((Widget)this.wAlterGroup);
        FormData fdgAlterGroup = new FormData();
        fdgAlterGroup.left = new FormAttachment(0, 0);
        fdgAlterGroup.right = new FormAttachment(100, 0);
        fdgAlterGroup.top = new FormAttachment((Control)this.wAction, margin * 2);
        this.wAlterGroup.setLayoutData((Object)fdgAlterGroup);
        Label wlAlterFailIfNotExists = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterFailIfNotExists.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Alter.FailIfNotExists.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterFailIfNotExists);
        FormData fdlAlterFailIfNotExists = new FormData();
        fdlAlterFailIfNotExists.left = new FormAttachment(0, 0);
        fdlAlterFailIfNotExists.top = new FormAttachment(0, margin);
        fdlAlterFailIfNotExists.right = new FormAttachment(middle, -margin);
        wlAlterFailIfNotExists.setLayoutData((Object)fdlAlterFailIfNotExists);
        this.wAlterFailIfNotExists = new Button((Composite)this.wAlterGroup, 32);
        PropsUi.setLook((Widget)this.wAlterFailIfNotExists);
        FormData fdAlterFailIfNotExists = new FormData();
        fdAlterFailIfNotExists.left = new FormAttachment(middle, 0);
        fdAlterFailIfNotExists.top = new FormAttachment(0, margin);
        fdAlterFailIfNotExists.right = new FormAttachment(100, 0);
        this.wAlterFailIfNotExists.setLayoutData((Object)fdAlterFailIfNotExists);
        this.wAlterFailIfNotExists.addListener(13, e -> this.warehouseManager.setChanged());
        Label wlAlterWarehouseSize = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterWarehouseSize.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.AlterWarehouseSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterWarehouseSize);
        FormData fdlAlterWarehouseSize = new FormData();
        fdlAlterWarehouseSize.left = new FormAttachment(0, 0);
        fdlAlterWarehouseSize.top = new FormAttachment((Control)this.wAlterFailIfNotExists, margin);
        fdlAlterWarehouseSize.right = new FormAttachment(middle, -margin);
        wlAlterWarehouseSize.setLayoutData((Object)fdlAlterWarehouseSize);
        this.wAlterWarehouseSize = new ComboVar(this.variables, (Composite)this.wAlterGroup, 18436);
        PropsUi.setLook((Widget)this.wAlterWarehouseSize);
        this.wAlterWarehouseSize.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdAlterWarehouseSize = new FormData();
        fdAlterWarehouseSize.left = new FormAttachment(middle, 0);
        fdAlterWarehouseSize.top = new FormAttachment((Control)this.wAlterFailIfNotExists, margin);
        fdAlterWarehouseSize.right = new FormAttachment(100, 0);
        this.wAlterWarehouseSize.setLayoutData((Object)fdAlterWarehouseSize);
        this.wAlterWarehouseSize.setItems(WAREHOUSE_SIZE_DESCS);
        Label wlAlterWarehouseType = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterWarehouseType.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.AlterWarehouseType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterWarehouseType);
        FormData fdlAlterWarehouseType = new FormData();
        fdlAlterWarehouseType.left = new FormAttachment(0, 0);
        fdlAlterWarehouseType.top = new FormAttachment((Control)this.wAlterWarehouseSize, margin);
        fdlAlterWarehouseType.right = new FormAttachment(middle, -margin);
        wlAlterWarehouseType.setLayoutData((Object)fdlAlterWarehouseType);
        this.wAlterWarehouseType = new ComboVar(this.variables, (Composite)this.wAlterGroup, 18436);
        PropsUi.setLook((Widget)this.wAlterWarehouseType);
        this.wAlterWarehouseType.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdAlterWarehouseType = new FormData();
        fdAlterWarehouseType.left = new FormAttachment(middle, 0);
        fdAlterWarehouseType.top = new FormAttachment((Control)this.wAlterWarehouseSize, margin);
        fdAlterWarehouseType.right = new FormAttachment(100, 0);
        this.wAlterWarehouseType.setLayoutData((Object)fdAlterWarehouseType);
        this.wAlterWarehouseType.setItems(WAREHOUSE_TYPE_DESCS);
        Label wlAlterMaxClusterSize = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterMaxClusterSize.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Alter.MaxClusterSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterMaxClusterSize);
        FormData fdlAlterMaxClusterSize = new FormData();
        fdlAlterMaxClusterSize.left = new FormAttachment(0, 0);
        fdlAlterMaxClusterSize.top = new FormAttachment((Control)this.wAlterWarehouseType, margin);
        fdlAlterMaxClusterSize.right = new FormAttachment(middle, -margin);
        wlAlterMaxClusterSize.setLayoutData((Object)fdlAlterMaxClusterSize);
        this.wAlterMaxClusterSize = new TextVar(this.variables, (Composite)this.wAlterGroup, 18436);
        PropsUi.setLook((Widget)this.wAlterGroup);
        this.wAlterMaxClusterSize.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdAlterMaxClusterSize = new FormData();
        fdAlterMaxClusterSize.left = new FormAttachment(middle, 0);
        fdAlterMaxClusterSize.right = new FormAttachment(100, 0);
        fdAlterMaxClusterSize.top = new FormAttachment((Control)this.wAlterWarehouseType, margin);
        this.wAlterMaxClusterSize.setLayoutData((Object)fdAlterMaxClusterSize);
        Label wlAlterMinClusterSize = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterMinClusterSize.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Alter.MinClusterSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterMinClusterSize);
        FormData fdlAlterMinClusterSize = new FormData();
        fdlAlterMinClusterSize.left = new FormAttachment(0, 0);
        fdlAlterMinClusterSize.top = new FormAttachment((Control)this.wAlterMaxClusterSize, margin);
        fdlAlterMinClusterSize.right = new FormAttachment(middle, -margin);
        wlAlterMinClusterSize.setLayoutData((Object)fdlAlterMinClusterSize);
        this.wAlterMinClusterSize = new TextVar(this.variables, (Composite)this.wAlterGroup, 18436);
        PropsUi.setLook((Widget)this.wAlterGroup);
        this.wAlterMinClusterSize.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdAlterMinClusterSize = new FormData();
        fdAlterMinClusterSize.left = new FormAttachment(middle, 0);
        fdAlterMinClusterSize.right = new FormAttachment(100, 0);
        fdAlterMinClusterSize.top = new FormAttachment((Control)this.wAlterMaxClusterSize, margin);
        this.wAlterMinClusterSize.setLayoutData((Object)fdAlterMinClusterSize);
        Label wlAlterAutoSuspend = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterAutoSuspend.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Alter.AutoSuspend.Label", (String[])new String[0]));
        wlAlterAutoSuspend.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Alter.AutoSuspend.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterAutoSuspend);
        FormData fdlAlterAutoSuspend = new FormData();
        fdlAlterAutoSuspend.left = new FormAttachment(0, 0);
        fdlAlterAutoSuspend.top = new FormAttachment((Control)this.wAlterMinClusterSize, margin);
        fdlAlterAutoSuspend.right = new FormAttachment(middle, -margin);
        wlAlterAutoSuspend.setLayoutData((Object)fdlAlterAutoSuspend);
        this.wAlterAutoSuspend = new TextVar(this.variables, (Composite)this.wAlterGroup, 18436);
        PropsUi.setLook((Widget)this.wAlterGroup);
        this.wAlterAutoSuspend.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdAlterAutoSuspend = new FormData();
        fdAlterAutoSuspend.left = new FormAttachment(middle, 0);
        fdAlterAutoSuspend.right = new FormAttachment(100, 0);
        fdAlterAutoSuspend.top = new FormAttachment((Control)this.wAlterMinClusterSize, margin);
        this.wAlterAutoSuspend.setLayoutData((Object)fdAlterAutoSuspend);
        Label wlAlterAutoResume = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterAutoResume.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Alter.AutoResume.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterAutoResume);
        FormData fdlAlterAutoResume = new FormData();
        fdlAlterAutoResume.left = new FormAttachment(0, 0);
        fdlAlterAutoResume.top = new FormAttachment((Control)this.wAlterAutoSuspend, margin);
        fdlAlterAutoResume.right = new FormAttachment(middle, -margin);
        wlAlterAutoResume.setLayoutData((Object)fdlAlterAutoResume);
        this.wAlterAutoResume = new Button((Composite)this.wAlterGroup, 32);
        PropsUi.setLook((Widget)this.wAlterAutoResume);
        FormData fdAlterAutoResume = new FormData();
        fdAlterAutoResume.left = new FormAttachment(middle, 0);
        fdAlterAutoResume.top = new FormAttachment((Control)this.wAlterAutoSuspend, margin);
        fdAlterAutoResume.right = new FormAttachment(100, 0);
        this.wAlterAutoResume.setLayoutData((Object)fdAlterAutoResume);
        this.wAlterAutoResume.addListener(13, e -> this.warehouseManager.setChanged());
        Label wlAlterResourceMonitor = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterResourceMonitor.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.ResourceMonitor.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterResourceMonitor);
        FormData fdlAlterResourceMonitor = new FormData();
        fdlAlterResourceMonitor.left = new FormAttachment(0, 0);
        fdlAlterResourceMonitor.top = new FormAttachment((Control)this.wAlterAutoResume, margin);
        fdlAlterResourceMonitor.right = new FormAttachment(middle, -margin);
        wlAlterResourceMonitor.setLayoutData((Object)fdlAlterResourceMonitor);
        this.wAlterResourceMonitor = new ComboVar(this.variables, (Composite)this.wAlterGroup, 18436);
        PropsUi.setLook((Widget)this.wAlterResourceMonitor);
        this.wAlterResourceMonitor.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdAlterResourceMonitor = new FormData();
        fdAlterResourceMonitor.left = new FormAttachment(middle, 0);
        fdAlterResourceMonitor.top = new FormAttachment((Control)this.wAlterAutoResume, margin);
        fdAlterResourceMonitor.right = new FormAttachment(100, 0);
        this.wAlterResourceMonitor.setLayoutData((Object)fdAlterResourceMonitor);
        this.wAlterResourceMonitor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WarehouseManagerDialog.this.getResourceMonitors();
            }
        });
        Label wlAlterComment = new Label((Composite)this.wAlterGroup, 131072);
        wlAlterComment.setText(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Dialog.Alter.Comment.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlterComment);
        FormData fdlAlterComment = new FormData();
        fdlAlterComment.left = new FormAttachment(0, 0);
        fdlAlterComment.top = new FormAttachment((Control)this.wAlterResourceMonitor, margin);
        fdlAlterComment.right = new FormAttachment(middle, -margin);
        wlAlterComment.setLayoutData((Object)fdlAlterComment);
        this.wAlterComment = new TextVar(this.variables, (Composite)this.wAlterGroup, 18436);
        PropsUi.setLook((Widget)this.wAlterGroup);
        this.wAlterComment.addListener(24, e -> this.warehouseManager.setChanged());
        FormData fdAlterComment = new FormData();
        fdAlterComment.left = new FormAttachment(middle, 0);
        fdAlterComment.right = new FormAttachment(100, 0);
        fdAlterComment.top = new FormAttachment((Control)this.wAlterResourceMonitor, margin);
        this.wAlterComment.setLayoutData((Object)fdAlterComment);
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOK, wCancel}, (int)margin, (Control)this.wCreateGroup);
        Listener lsCancel = e -> this.cancel();
        Listener lsOK = e -> this.ok();
        wOK.addListener(13, lsOK);
        wCancel.addListener(13, lsCancel);
        this.wName.addListener(24, e -> this.warehouseManager.setChanged());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                WarehouseManagerDialog.this.cancel();
            }
        });
        this.getData();
        this.setFlags();
        BaseTransformDialog.setSize((Shell)this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "WarehouseManagerSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.warehouseManager;
    }

    public void setFlags() {
        this.wCreateFailIfExists.setEnabled(!this.wCreateReplace.getSelection());
        this.wCreateGroup.setVisible(this.wAction.getSelectionIndex() == 0);
        this.wDropGroup.setVisible(this.wAction.getSelectionIndex() == 1);
        this.wResumeGroup.setVisible(this.wAction.getSelectionIndex() == 2);
        this.wSuspendGroup.setVisible(this.wAction.getSelectionIndex() == 3);
        this.wAlterGroup.setVisible(this.wAction.getSelectionIndex() == 4);
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.warehouseManager.getName(), (String)""));
        this.wConnection.setText(this.warehouseManager.getDatabaseMeta() != null ? this.warehouseManager.getDatabaseMeta().getName() : "");
        this.wWarehouseName.setText(Const.NVL((String)this.warehouseManager.getWarehouseName(), (String)""));
        int actionId = this.warehouseManager.getManagementActionId();
        if (actionId >= 0 && actionId < MANAGEMENT_ACTION_DESCS.length) {
            this.wAction.setText(MANAGEMENT_ACTION_DESCS[actionId]);
        }
        this.wCreateReplace.setSelection(this.warehouseManager.isReplace());
        this.wCreateFailIfExists.setSelection(this.warehouseManager.isFailIfExists());
        int warehouseSizeId = this.warehouseManager.getWarehouseSizeId();
        if (warehouseSizeId >= 0 && warehouseSizeId < WAREHOUSE_SIZE_DESCS.length) {
            this.wCreateWarehouseSize.setText(WAREHOUSE_SIZE_DESCS[warehouseSizeId]);
        } else {
            this.wCreateWarehouseSize.setText(Const.NVL((String)this.warehouseManager.getWarehouseSize(), (String)""));
        }
        int warehouseTypeId = this.warehouseManager.getWarehouseTypeId();
        if (warehouseTypeId >= 0 && warehouseTypeId < WAREHOUSE_TYPE_DESCS.length) {
            this.wCreateWarehouseType.setText(WAREHOUSE_TYPE_DESCS[warehouseTypeId]);
        } else {
            this.wCreateWarehouseType.setText(Const.NVL((String)this.warehouseManager.getWarehouseType(), (String)""));
        }
        this.wCreateMaxClusterSize.setText(Const.NVL((String)this.warehouseManager.getMaxClusterCount(), (String)""));
        this.wCreateMinClusterSize.setText(Const.NVL((String)this.warehouseManager.getMinClusterCount(), (String)""));
        this.wCreateAutoSuspend.setText(Const.NVL((String)this.warehouseManager.getAutoSuspend(), (String)""));
        this.wCreateAutoResume.setSelection(this.warehouseManager.isAutoResume());
        this.wCreateInitialSuspend.setSelection(this.warehouseManager.isInitiallySuspended());
        this.wCreateResourceMonitor.setText(Const.NVL((String)this.warehouseManager.getResourceMonitor(), (String)""));
        this.wCreateComment.setText(Const.NVL((String)this.warehouseManager.getComment(), (String)""));
        this.wDropFailIfNotExists.setSelection(this.warehouseManager.isFailIfNotExists());
        this.wResumeFailIfNotExists.setSelection(this.warehouseManager.isFailIfNotExists());
        this.wSuspendFailIfNotExists.setSelection(this.warehouseManager.isFailIfNotExists());
        this.wAlterFailIfNotExists.setSelection(this.warehouseManager.isFailIfNotExists());
        if (warehouseSizeId >= 0 && warehouseSizeId < WAREHOUSE_SIZE_DESCS.length) {
            this.wAlterWarehouseSize.setText(WAREHOUSE_SIZE_DESCS[warehouseSizeId]);
        } else {
            this.wAlterWarehouseSize.setText(Const.NVL((String)this.warehouseManager.getWarehouseSize(), (String)""));
        }
        if (warehouseTypeId >= 0 && warehouseTypeId < WAREHOUSE_TYPE_DESCS.length) {
            this.wAlterWarehouseType.setText(WAREHOUSE_TYPE_DESCS[warehouseTypeId]);
        } else {
            this.wAlterWarehouseType.setText(Const.NVL((String)this.warehouseManager.getWarehouseType(), (String)""));
        }
        this.wAlterMaxClusterSize.setText(Const.NVL((String)this.warehouseManager.getMaxClusterCount(), (String)""));
        this.wAlterMinClusterSize.setText(Const.NVL((String)this.warehouseManager.getMinClusterCount(), (String)""));
        this.wAlterAutoSuspend.setText(Const.NVL((String)this.warehouseManager.getAutoSuspend(), (String)""));
        this.wAlterAutoResume.setSelection(this.warehouseManager.isAutoResume());
        this.wAlterResourceMonitor.setText(Const.NVL((String)this.warehouseManager.getResourceMonitor(), (String)""));
        this.wAlterComment.setText(Const.NVL((String)this.warehouseManager.getComment(), (String)""));
        if (StringUtil.isEmpty((String)this.wAction.getText())) {
            this.wAction.setText(MANAGEMENT_ACTION_DESCS[0]);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.warehouseManager.setChanged(this.backupChanged);
        this.warehouseManager = null;
        this.dispose();
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.warehouseManager.setName(this.wName.getText());
        this.warehouseManager.setDatabaseMeta(this.workflowMeta.findDatabase(Const.NVL((String)this.wConnection.getText(), (String)""), this.variables));
        this.warehouseManager.setWarehouseName(this.wWarehouseName.getText());
        this.warehouseManager.setManagementActionById(this.wAction.getSelectionIndex());
        if (this.wAction.getSelectionIndex() == 0) {
            this.warehouseManager.setReplace(this.wCreateReplace.getSelection());
            this.warehouseManager.setFailIfExists(this.wCreateFailIfExists.getSelection());
            boolean warehouseSizeFound = false;
            for (int i = 0; i < WAREHOUSE_SIZE_DESCS.length; ++i) {
                if (!this.wCreateWarehouseSize.getText().equals(WAREHOUSE_SIZE_DESCS[i])) continue;
                warehouseSizeFound = true;
                this.warehouseManager.setWarehouseSizeById(i);
                break;
            }
            if (!warehouseSizeFound) {
                this.warehouseManager.setWarehouseSize(this.wCreateWarehouseSize.getText());
            }
            boolean warehouseTypeFound = false;
            for (int i = 0; i < WAREHOUSE_TYPE_DESCS.length; ++i) {
                if (!this.wCreateWarehouseType.getText().equals(WAREHOUSE_TYPE_DESCS[i])) continue;
                warehouseTypeFound = true;
                this.warehouseManager.setWarehouseTypeById(i);
                break;
            }
            if (!warehouseTypeFound) {
                this.warehouseManager.setWarehouseType(this.wCreateWarehouseType.getText());
            }
            this.warehouseManager.setMaxClusterCount(this.wCreateMaxClusterSize.getText());
            this.warehouseManager.setMinClusterCount(this.wCreateMinClusterSize.getText());
            this.warehouseManager.setAutoResume(this.wCreateAutoResume.getSelection());
            this.warehouseManager.setAutoSuspend(this.wCreateAutoSuspend.getText());
            this.warehouseManager.setInitiallySuspended(this.wCreateInitialSuspend.getSelection());
            this.warehouseManager.setResourceMonitor(this.wCreateResourceMonitor.getText());
            this.warehouseManager.setComment(this.wCreateComment.getText());
        } else if (this.wAction.getSelectionIndex() == 1) {
            this.warehouseManager.setFailIfNotExists(this.wDropFailIfNotExists.getSelection());
        } else if (this.wAction.getSelectionIndex() == 2) {
            this.warehouseManager.setFailIfNotExists(this.wResumeFailIfNotExists.getSelection());
        } else if (this.wAction.getSelectionIndex() == 3) {
            this.warehouseManager.setFailIfNotExists(this.wSuspendFailIfNotExists.getSelection());
        } else if (this.wAction.getSelectionIndex() == 4) {
            this.warehouseManager.setFailIfNotExists(this.wAlterFailIfNotExists.getSelection());
            boolean warehouseSizeFound = false;
            for (int i = 0; i < WAREHOUSE_SIZE_DESCS.length; ++i) {
                if (!this.wAlterWarehouseSize.getText().equals(WAREHOUSE_SIZE_DESCS[i])) continue;
                warehouseSizeFound = true;
                this.warehouseManager.setWarehouseSizeById(i);
                break;
            }
            if (!warehouseSizeFound) {
                this.warehouseManager.setWarehouseSize(this.wAlterWarehouseSize.getText());
            }
            boolean warehouseTypeFound = false;
            for (int i = 0; i < WAREHOUSE_TYPE_DESCS.length; ++i) {
                if (!this.wAlterWarehouseType.getText().equals(WAREHOUSE_TYPE_DESCS[i])) continue;
                warehouseTypeFound = true;
                this.warehouseManager.setWarehouseTypeById(i);
                break;
            }
            if (!warehouseTypeFound) {
                this.warehouseManager.setWarehouseType(this.wAlterWarehouseType.getText());
            }
            this.warehouseManager.setMaxClusterCount(this.wAlterMaxClusterSize.getText());
            this.warehouseManager.setMinClusterCount(this.wAlterMinClusterSize.getText());
            this.warehouseManager.setAutoResume(this.wAlterAutoResume.getSelection());
            this.warehouseManager.setAutoSuspend(this.wAlterAutoSuspend.getText());
            this.warehouseManager.setResourceMonitor(this.wAlterResourceMonitor.getText());
            this.warehouseManager.setComment(this.wAlterComment.getText());
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResourceMonitors() {
        DatabaseMeta databaseMeta = this.workflowMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            String warehouseName = this.wWarehouseName.getText();
            this.wWarehouseName.removeAll();
            Database db = null;
            try {
                db = new Database(loggingObject, this.variables, databaseMeta);
                db.connect();
                ResultSet resultSet = db.openQuery("show resource monitors;", null, null, 1000, false);
                IRowMeta rowMeta = db.getReturnRowMeta();
                Object[] row = db.getRow(resultSet);
                int nameField = rowMeta.indexOfValue("NAME");
                if (nameField >= 0) {
                    while (row != null) {
                        String name = rowMeta.getString(row, nameField);
                        this.wWarehouseName.add(name);
                        row = db.getRow(resultSet);
                    }
                } else {
                    throw new HopException("Unable to find resource monitor name field in result");
                }
                db.closeQuery(resultSet);
                if (warehouseName != null) {
                    this.wWarehouseName.setText(warehouseName);
                }
            }
            catch (Exception ex) {
                this.warehouseManager.logDebug("Error getting resource monitors", new Object[]{ex});
            }
            finally {
                if (db != null) {
                    db.disconnect();
                }
            }
        }
    }
}

