/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Arrays;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MovingFunction {
    private final @UnknownKeyFor @NonNull @Initialized long sampleUpdateMs;
    private final @UnknownKeyFor @NonNull @Initialized int numSignificantBuckets;
    private final @UnknownKeyFor @NonNull @Initialized int numSignificantSamples;
    private final  @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn function;
    private final @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] buckets;
    private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] numSamples;
    private @UnknownKeyFor @NonNull @Initialized long currentMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized int currentIndex;

    public MovingFunction(@UnknownKeyFor @NonNull @Initialized long samplePeriodMs, @UnknownKeyFor @NonNull @Initialized long sampleUpdateMs, @UnknownKeyFor @NonNull @Initialized int numSignificantBuckets, @UnknownKeyFor @NonNull @Initialized int numSignificantSamples,  @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn function) {
        this.sampleUpdateMs = sampleUpdateMs;
        this.numSignificantBuckets = numSignificantBuckets;
        this.numSignificantSamples = numSignificantSamples;
        this.function = function;
        int n = (int)(samplePeriodMs / sampleUpdateMs);
        this.buckets = new long[n];
        Arrays.fill(this.buckets, function.identity());
        this.numSamples = new int[n];
        Arrays.fill(this.numSamples, 0);
        this.currentMsSinceEpoch = -1L;
        this.currentIndex = 0;
    }

    private void flush(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch) {
        Preconditions.checkArgument((nowMsSinceEpoch >= 0L ? 1 : 0) != 0, (Object)"Only positive timestamps supported");
        Preconditions.checkArgument((nowMsSinceEpoch >= this.currentMsSinceEpoch ? 1 : 0) != 0, (Object)"Attempting to move backwards");
        this.currentMsSinceEpoch = nowMsSinceEpoch - nowMsSinceEpoch % this.sampleUpdateMs;
        for (int newBuckets = Math.min((int)((nowMsSinceEpoch - this.currentMsSinceEpoch) / this.sampleUpdateMs), this.buckets.length); newBuckets > 0; --newBuckets) {
            this.currentIndex = (this.currentIndex + 1) % this.buckets.length;
            this.buckets[this.currentIndex] = this.function.identity();
            this.numSamples[this.currentIndex] = 0;
        }
    }

    public void add(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized long value) {
        this.flush(nowMsSinceEpoch);
        this.buckets[this.currentIndex] = this.function.apply(this.buckets[this.currentIndex], value);
        int n = this.currentIndex;
        this.numSamples[n] = this.numSamples[n] + 1;
    }

    public @UnknownKeyFor @NonNull @Initialized long get(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch) {
        this.flush(nowMsSinceEpoch);
        long result = this.function.identity();
        for (long bucket : this.buckets) {
            result = this.function.apply(result, bucket);
        }
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSignificant() {
        int totalSamples = 0;
        int activeBuckets = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            totalSamples += this.numSamples[i];
            if (this.numSamples[i] <= 0) continue;
            ++activeBuckets;
        }
        return activeBuckets >= this.numSignificantBuckets || totalSamples >= this.numSignificantSamples;
    }
}

