/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunner
extends Thread {
    protected Task<?> tsk;
    protected TaskResult result;
    protected SessionState ss;
    private static AtomicLong taskCounter = new AtomicLong(0L);
    private static ThreadLocal<Long> taskRunnerID = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return taskCounter.incrementAndGet();
        }
    };
    protected Thread runner;
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunner.class);
    private final TaskQueue taskQueue;

    public TaskRunner(Task<?> tsk, TaskQueue taskQueue) {
        this.tsk = tsk;
        this.result = new TaskResult();
        this.ss = SessionState.get();
        this.taskQueue = taskQueue;
    }

    public Task<?> getTask() {
        return this.tsk;
    }

    public TaskResult getTaskResult() {
        return this.result;
    }

    public Thread getRunner() {
        return this.runner;
    }

    public boolean isRunning() {
        return this.result.isRunning();
    }

    @Override
    public void run() {
        LogUtils.registerLoggingContext((Configuration)this.tsk.getConf());
        this.runner = Thread.currentThread();
        try {
            SessionState.start(this.ss);
            LogUtils.registerLoggingContext((Configuration)this.tsk.conf);
            this.runSequential();
        }
        finally {
            try {
                Hive.closeCurrent();
            }
            catch (Exception e) {
                LOG.warn("Exception closing Metastore connection:" + e.getMessage());
            }
            LogUtils.unregisterLoggingContext();
            this.runner = null;
            this.result.setRunning(false);
        }
    }

    public void runSequential() {
        int exitVal = -101;
        try {
            exitVal = this.tsk.executeTask(this.ss == null ? null : this.ss.getHiveHistory());
        }
        catch (Throwable t) {
            if (this.tsk.getException() == null) {
                this.tsk.setException(t);
            }
            LOG.error("Error in executeTask", t);
        }
        if (this.tsk.getException() != null) {
            this.result.setTaskError(this.tsk.getException());
        }
        this.result.setExitVal(exitVal);
        this.taskQueue.releaseRunnable();
    }

    public static long getTaskRunnerID() {
        return taskRunnerID.get();
    }
}

