/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Resource plans", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowResourcePlanDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 6076076933035978545L;
    private static final String ALL_SCHEMA = "rp_name,status,query_parallelism#string,string,int";
    private static final String SINGLE_SCHEMA = "line#string";
    private final String resourcePlanName;
    private final String resFile;

    public ShowResourcePlanDesc(String resourcePlanName, String resFile) {
        this.resourcePlanName = resourcePlanName;
        this.resFile = resFile;
    }

    @Explain(displayName="Resource plan name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getResourcePlanName() {
        return this.resourcePlanName;
    }

    @Explain(displayName="Result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public String getSchema() {
        return this.resourcePlanName == null ? ALL_SCHEMA : SINGLE_SCHEMA;
    }
}

