/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.concurrent.TimeUnit;

public class OpTimer {
    private boolean isStarted;
    private long startNanos;
    private long currentElapsedNanos;

    public boolean isRunning() {
        return this.isStarted;
    }

    public OpTimer start() throws IllegalStateException {
        if (this.isStarted) {
            throw new IllegalStateException("OpTimer is already running");
        }
        this.isStarted = true;
        this.startNanos = System.nanoTime();
        return this;
    }

    public OpTimer stop() throws IllegalStateException {
        if (!this.isStarted) {
            throw new IllegalStateException("OpTimer is already stopped");
        }
        long now = System.nanoTime();
        this.isStarted = false;
        this.currentElapsedNanos += now - this.startNanos;
        return this;
    }

    public OpTimer reset() {
        this.currentElapsedNanos = 0L;
        this.isStarted = false;
        return this;
    }

    public long now(TimeUnit timeUnit) {
        return timeUnit.convert(this.now(), TimeUnit.NANOSECONDS);
    }

    public double scale(TimeUnit timeUnit) {
        return (double)this.now() / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
    }

    public long now() {
        return this.isStarted ? System.nanoTime() - this.startNanos + this.currentElapsedNanos : this.currentElapsedNanos;
    }

    public String toString() {
        return String.valueOf(this.now());
    }
}

