/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hive.beeline.BeeLine;

class Reflector {
    private final BeeLine beeLine;

    public Reflector(BeeLine beeLine) {
        this.beeLine = beeLine;
    }

    public Object invoke(Object on, String method, Object[] args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        return this.invoke(on, method, Arrays.asList(args));
    }

    public Object invoke(Object on, String method, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        return this.invoke(on, on == null ? null : on.getClass(), method, args);
    }

    public Object invoke(Object on, Class defClass, String method, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = defClass != null ? defClass : on.getClass();
        LinkedList<Method> candidateMethods = new LinkedList<Method>();
        Method[] m = c.getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().equalsIgnoreCase(method)) continue;
            candidateMethods.add(m[i]);
        }
        if (candidateMethods.size() == 0) {
            throw new IllegalArgumentException(this.beeLine.loc("no-method", new Object[]{method, c.getName()}));
        }
        for (Method meth : candidateMethods) {
            Object[] converted;
            Class[] ptypes = meth.getParameterTypes();
            if (ptypes.length != args.size() || (converted = Reflector.convert(args, ptypes)) == null || !Modifier.isPublic(meth.getModifiers())) continue;
            return meth.invoke(on, converted);
        }
        return null;
    }

    public static Object[] convert(List objects, Class[] toTypes) throws ClassNotFoundException {
        Object[] converted = new Object[objects.size()];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = Reflector.convert(objects.get(i), toTypes[i]);
        }
        return converted;
    }

    public static Object convert(Object ob, Class toType) throws ClassNotFoundException {
        if (ob == null || ob.toString().equals("null")) {
            return null;
        }
        if (toType == String.class) {
            return new String(ob.toString());
        }
        if (toType == Map.class) {
            String[] vars = ob.toString().split(",");
            HashMap<String, String> keyValMap = new HashMap<String, String>();
            for (String keyValStr : vars) {
                String[] keyVal = keyValStr.trim().split("=", 2);
                if (keyVal.length != 2) continue;
                keyValMap.put(keyVal[0], keyVal[1]);
            }
            return keyValMap;
        }
        if (toType == Byte.class || toType == Byte.TYPE) {
            return Byte.valueOf(ob.toString());
        }
        if (toType == Character.class || toType == Character.TYPE) {
            return Character.valueOf(ob.toString().charAt(0));
        }
        if (toType == Short.class || toType == Short.TYPE) {
            return Short.valueOf(ob.toString());
        }
        if (toType == Integer.class || toType == Integer.TYPE) {
            return Integer.valueOf(ob.toString());
        }
        if (toType == Long.class || toType == Long.TYPE) {
            return Long.valueOf(ob.toString());
        }
        if (toType == Double.class || toType == Double.TYPE) {
            return Double.valueOf(ob.toString());
        }
        if (toType == Float.class || toType == Float.TYPE) {
            return Float.valueOf(ob.toString());
        }
        if (toType == Boolean.class || toType == Boolean.TYPE) {
            return ob.toString().equals("true") || ob.toString().equals("true") || ob.toString().equals("1") || ob.toString().equals("on") || ob.toString().equals("yes");
        }
        if (toType == Class.class) {
            return Class.forName(ob.toString());
        }
        return null;
    }
}

