/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.wrappedio.impl;

import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.dynamic.BindingUtils;
import org.apache.hadoop.util.dynamic.DynMethods;

public final class DynamicWrappedStatistics {
    public static final String WRAPPED_STATISTICS_CLASSNAME = "org.apache.hadoop.io.wrappedio.WrappedStatistics";
    public static final String IS_IOSTATISTICS_SOURCE = "isIOStatisticsSource";
    public static final String IS_IOSTATISTICS = "isIOStatistics";
    public static final String IS_IOSTATISTICS_SNAPSHOT = "isIOStatisticsSnapshot";
    public static final String IOSTATISTICS_CONTEXT_AGGREGATE = "iostatisticsContext_aggregate";
    public static final String IOSTATISTICS_CONTEXT_ENABLED = "iostatisticsContext_enabled";
    public static final String IOSTATISTICS_CONTEXT_GET_CURRENT = "iostatisticsContext_getCurrent";
    public static final String IOSTATISTICS_CONTEXT_SET_THREAD_CONTEXT = "iostatisticsContext_setThreadIOStatisticsContext";
    public static final String IOSTATISTICS_CONTEXT_RESET = "iostatisticsContext_reset";
    public static final String IOSTATISTICS_CONTEXT_SNAPSHOT = "iostatisticsContext_snapshot";
    public static final String IOSTATISTICS_SNAPSHOT_AGGREGATE = "iostatisticsSnapshot_aggregate";
    public static final String IOSTATISTICS_SNAPSHOT_CREATE = "iostatisticsSnapshot_create";
    public static final String IOSTATISTICS_SNAPSHOT_FROM_JSON_STRING = "iostatisticsSnapshot_fromJsonString";
    public static final String IOSTATISTICS_SNAPSHOT_LOAD = "iostatisticsSnapshot_load";
    public static final String IOSTATISTICS_SNAPSHOT_RETRIEVE = "iostatisticsSnapshot_retrieve";
    public static final String IOSTATISTICS_SNAPSHOT_SAVE = "iostatisticsSnapshot_save";
    public static final String IOSTATISTICS_SNAPSHOT_TO_JSON_STRING = "iostatisticsSnapshot_toJsonString";
    public static final String IOSTATISTICS_TO_PRETTY_STRING = "iostatistics_toPrettyString";
    public static final String IOSTATISTICS_COUNTERS = "iostatistics_counters";
    public static final String IOSTATISTICS_GAUGES = "iostatistics_gauges";
    public static final String IOSTATISTICS_MINIMUMS = "iostatistics_minimums";
    public static final String IOSTATISTICS_MAXIMUMS = "iostatistics_maximums";
    public static final String IOSTATISTICS_MEANS = "iostatistics_means";
    private final boolean loaded;
    private final DynMethods.UnboundMethod iostatisticsContextAggregateMethod;
    private final DynMethods.UnboundMethod iostatisticsContextEnabledMethod;
    private final DynMethods.UnboundMethod iostatisticsContextGetCurrentMethod;
    private final DynMethods.UnboundMethod iostatisticsContextResetMethod;
    private final DynMethods.UnboundMethod iostatisticsContextSetThreadContextMethod;
    private final DynMethods.UnboundMethod iostatisticsContextSnapshotMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotAggregateMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotCreateMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotCreateWithSourceMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotLoadMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotFromJsonStringMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotRetrieveMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotSaveMethod;
    private final DynMethods.UnboundMethod iostatisticsToPrettyStringMethod;
    private final DynMethods.UnboundMethod iostatisticsSnapshotToJsonStringMethod;
    private final DynMethods.UnboundMethod iostatisticsCountersMethod;
    private final DynMethods.UnboundMethod iostatisticsGaugesMethod;
    private final DynMethods.UnboundMethod iostatisticsMinimumsMethod;
    private final DynMethods.UnboundMethod iostatisticsMaximumsMethod;
    private final DynMethods.UnboundMethod iostatisticsMeansMethod;
    private final DynMethods.UnboundMethod isIOStatisticsSourceMethod;
    private final DynMethods.UnboundMethod isIOStatisticsMethod;
    private final DynMethods.UnboundMethod isIOStatisticsSnapshotMethod;

    public DynamicWrappedStatistics() {
        this(WRAPPED_STATISTICS_CLASSNAME);
    }

    public DynamicWrappedStatistics(String classname) {
        Class wrappedClass = BindingUtils.loadClass((String)classname);
        this.loaded = wrappedClass != null;
        this.isIOStatisticsSourceMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.class, (String)IS_IOSTATISTICS_SOURCE, (Class[])new Class[]{Object.class});
        this.isIOStatisticsMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.class, (String)IS_IOSTATISTICS, (Class[])new Class[]{Object.class});
        this.isIOStatisticsSnapshotMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.class, (String)IS_IOSTATISTICS_SNAPSHOT, (Class[])new Class[]{Serializable.class});
        this.iostatisticsContextAggregateMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.class, (String)IOSTATISTICS_CONTEXT_AGGREGATE, (Class[])new Class[]{Object.class});
        this.iostatisticsContextEnabledMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.class, (String)IOSTATISTICS_CONTEXT_ENABLED, (Class[])new Class[0]);
        this.iostatisticsContextGetCurrentMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Object.class, (String)IOSTATISTICS_CONTEXT_GET_CURRENT, (Class[])new Class[0]);
        this.iostatisticsContextResetMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Void.class, (String)IOSTATISTICS_CONTEXT_RESET, (Class[])new Class[0]);
        this.iostatisticsContextSetThreadContextMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Void.class, (String)IOSTATISTICS_CONTEXT_SET_THREAD_CONTEXT, (Class[])new Class[]{Object.class});
        this.iostatisticsContextSnapshotMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Serializable.class, (String)IOSTATISTICS_CONTEXT_SNAPSHOT, (Class[])new Class[0]);
        this.iostatisticsSnapshotAggregateMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Boolean.class, (String)IOSTATISTICS_SNAPSHOT_AGGREGATE, (Class[])new Class[]{Serializable.class, Object.class});
        this.iostatisticsSnapshotCreateMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Serializable.class, (String)IOSTATISTICS_SNAPSHOT_CREATE, (Class[])new Class[0]);
        this.iostatisticsSnapshotCreateWithSourceMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Serializable.class, (String)IOSTATISTICS_SNAPSHOT_CREATE, (Class[])new Class[]{Object.class});
        this.iostatisticsSnapshotFromJsonStringMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Serializable.class, (String)IOSTATISTICS_SNAPSHOT_FROM_JSON_STRING, (Class[])new Class[]{String.class});
        this.iostatisticsSnapshotToJsonStringMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, String.class, (String)IOSTATISTICS_SNAPSHOT_TO_JSON_STRING, (Class[])new Class[]{Serializable.class});
        this.iostatisticsSnapshotRetrieveMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Serializable.class, (String)IOSTATISTICS_SNAPSHOT_RETRIEVE, (Class[])new Class[]{Object.class});
        this.iostatisticsSnapshotLoadMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Serializable.class, (String)IOSTATISTICS_SNAPSHOT_LOAD, (Class[])new Class[]{FileSystem.class, Path.class});
        this.iostatisticsSnapshotSaveMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Void.class, (String)IOSTATISTICS_SNAPSHOT_SAVE, (Class[])new Class[]{Serializable.class, FileSystem.class, Path.class, Boolean.TYPE});
        this.iostatisticsCountersMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Map.class, (String)IOSTATISTICS_COUNTERS, (Class[])new Class[]{Serializable.class});
        this.iostatisticsGaugesMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Map.class, (String)IOSTATISTICS_GAUGES, (Class[])new Class[]{Serializable.class});
        this.iostatisticsMinimumsMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Map.class, (String)IOSTATISTICS_MINIMUMS, (Class[])new Class[]{Serializable.class});
        this.iostatisticsMaximumsMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Map.class, (String)IOSTATISTICS_MAXIMUMS, (Class[])new Class[]{Serializable.class});
        this.iostatisticsMeansMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, Map.class, (String)IOSTATISTICS_MEANS, (Class[])new Class[]{Serializable.class});
        this.iostatisticsToPrettyStringMethod = BindingUtils.loadStaticMethod((Class)wrappedClass, String.class, (String)IOSTATISTICS_TO_PRETTY_STRING, (Class[])new Class[]{Object.class});
    }

    public boolean loaded() {
        return this.loaded;
    }

    public boolean ioStatisticsAvailable() {
        return BindingUtils.available((DynMethods.UnboundMethod)this.iostatisticsSnapshotCreateMethod);
    }

    public boolean ioStatisticsContextAvailable() {
        return BindingUtils.available((DynMethods.UnboundMethod)this.iostatisticsContextEnabledMethod);
    }

    private void checkIoStatisticsAvailable() {
        BindingUtils.checkAvailable((DynMethods.UnboundMethod)this.iostatisticsSnapshotCreateMethod);
    }

    private void checkIoStatisticsContextAvailable() {
        BindingUtils.checkAvailable((DynMethods.UnboundMethod)this.iostatisticsContextEnabledMethod);
    }

    public boolean isIOStatisticsSource(Object object) {
        return this.ioStatisticsAvailable() && (Boolean)this.isIOStatisticsSourceMethod.invoke(null, new Object[]{object}) != false;
    }

    public boolean isIOStatistics(Object object) {
        return this.ioStatisticsAvailable() && (Boolean)this.isIOStatisticsMethod.invoke(null, new Object[]{object}) != false;
    }

    public boolean isIOStatisticsSnapshot(Serializable object) {
        return this.ioStatisticsAvailable() && (Boolean)this.isIOStatisticsSnapshotMethod.invoke(null, new Object[]{object}) != false;
    }

    public boolean iostatisticsContext_enabled() {
        return this.ioStatisticsAvailable() && (Boolean)this.iostatisticsContextEnabledMethod.invoke(null, new Object[0]) != false;
    }

    public Object iostatisticsContext_getCurrent() throws UnsupportedOperationException {
        this.checkIoStatisticsContextAvailable();
        return this.iostatisticsContextGetCurrentMethod.invoke(null, new Object[0]);
    }

    public void iostatisticsContext_setThreadIOStatisticsContext(@Nullable Object statisticsContext) throws UnsupportedOperationException {
        this.checkIoStatisticsContextAvailable();
        this.iostatisticsContextSetThreadContextMethod.invoke(null, new Object[]{statisticsContext});
    }

    public void iostatisticsContext_reset() throws UnsupportedOperationException {
        this.checkIoStatisticsContextAvailable();
        this.iostatisticsContextResetMethod.invoke(null, new Object[0]);
    }

    public Serializable iostatisticsContext_snapshot() throws UnsupportedOperationException {
        this.checkIoStatisticsContextAvailable();
        return (Serializable)this.iostatisticsContextSnapshotMethod.invoke(null, new Object[0]);
    }

    public boolean iostatisticsContext_aggregate(Object source) {
        this.checkIoStatisticsContextAvailable();
        return (Boolean)this.iostatisticsContextAggregateMethod.invoke(null, new Object[]{source});
    }

    public boolean iostatisticsSnapshot_aggregate(Serializable snapshot, @Nullable Object statistics) throws UnsupportedOperationException {
        this.checkIoStatisticsAvailable();
        return (Boolean)this.iostatisticsSnapshotAggregateMethod.invoke(null, new Object[]{snapshot, statistics});
    }

    public Serializable iostatisticsSnapshot_create() throws UnsupportedOperationException {
        this.checkIoStatisticsAvailable();
        return (Serializable)this.iostatisticsSnapshotCreateMethod.invoke(null, new Object[0]);
    }

    public Serializable iostatisticsSnapshot_create(@Nullable Object source) throws UnsupportedOperationException, ClassCastException {
        this.checkIoStatisticsAvailable();
        return (Serializable)this.iostatisticsSnapshotCreateWithSourceMethod.invoke(null, new Object[]{source});
    }

    public String iostatisticsSnapshot_toJsonString(@Nullable Serializable snapshot) throws UncheckedIOException, UnsupportedOperationException {
        this.checkIoStatisticsAvailable();
        return (String)this.iostatisticsSnapshotToJsonStringMethod.invoke(null, new Object[]{snapshot});
    }

    public Serializable iostatisticsSnapshot_fromJsonString(String json) throws UncheckedIOException, UnsupportedOperationException {
        this.checkIoStatisticsAvailable();
        return (Serializable)this.iostatisticsSnapshotFromJsonStringMethod.invoke(null, new Object[]{json});
    }

    public Serializable iostatisticsSnapshot_load(FileSystem fs, Path path) throws UncheckedIOException, UnsupportedOperationException {
        this.checkIoStatisticsAvailable();
        return (Serializable)this.iostatisticsSnapshotLoadMethod.invoke(null, new Object[]{fs, path});
    }

    public Serializable iostatisticsSnapshot_retrieve(@Nullable Object source) throws UnsupportedOperationException {
        this.checkIoStatisticsAvailable();
        return (Serializable)this.iostatisticsSnapshotRetrieveMethod.invoke(null, new Object[]{source});
    }

    public void iostatisticsSnapshot_save(@Nullable Serializable snapshot, FileSystem fs, Path path, boolean overwrite) throws UncheckedIOException, UnsupportedOperationException {
        this.checkIoStatisticsAvailable();
        this.iostatisticsSnapshotSaveMethod.invoke(null, new Object[]{snapshot, fs, path, overwrite});
    }

    public Map<String, Long> iostatistics_counters(Serializable source) {
        return (Map)this.iostatisticsCountersMethod.invoke(null, new Object[]{source});
    }

    public Map<String, Long> iostatistics_gauges(Serializable source) {
        return (Map)this.iostatisticsGaugesMethod.invoke(null, new Object[]{source});
    }

    public Map<String, Long> iostatistics_minimums(Serializable source) {
        return (Map)this.iostatisticsMinimumsMethod.invoke(null, new Object[]{source});
    }

    public Map<String, Long> iostatistics_maximums(Serializable source) {
        return (Map)this.iostatisticsMaximumsMethod.invoke(null, new Object[]{source});
    }

    public Map<String, Map.Entry<Long, Long>> iostatistics_means(Serializable source) {
        return (Map)this.iostatisticsMeansMethod.invoke(null, new Object[]{source});
    }

    public String iostatistics_toPrettyString(Object statistics) {
        this.checkIoStatisticsAvailable();
        return (String)this.iostatisticsToPrettyStringMethod.invoke(null, new Object[]{statistics});
    }

    public String toString() {
        return "DynamicWrappedStatistics{ioStatisticsAvailable =" + this.ioStatisticsAvailable() + ", ioStatisticsContextAvailable =" + this.ioStatisticsContextAvailable() + '}';
    }
}

