/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.DelimitedJSONSerDe;
import org.apache.hadoop.hive.serde2.FetchFormatter;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hive.common.util.ReflectionUtil;

public class DefaultFetchFormatter<T>
implements FetchFormatter<String> {
    private AbstractSerDe mSerde;

    @Override
    public void initialize(Configuration hconf, Properties props) throws SerDeException {
        this.mSerde = this.initializeSerde(hconf, props);
    }

    private AbstractSerDe initializeSerde(Configuration conf, Properties props) throws SerDeException {
        Class<AbstractSerDe> serdeClass;
        String serdeName = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_FETCH_OUTPUT_SERDE);
        try {
            serdeClass = Class.forName(serdeName, true, JavaUtils.getClassLoader()).asSubclass(AbstractSerDe.class);
        }
        catch (ClassNotFoundException e) {
            throw new SerDeException(e);
        }
        AbstractSerDe serde = ReflectionUtil.newInstance(serdeClass, null);
        Properties serdeProps = new Properties();
        if (serde instanceof DelimitedJSONSerDe) {
            serdeProps.put("serialization.format", props.getProperty("serialization.format"));
            serdeProps.put("serialization.null.format", props.getProperty("serialization.null.format"));
        }
        serde.initialize(conf, serdeProps, null);
        return serde;
    }

    @Override
    public String convert(Object row, ObjectInspector rowOI) throws Exception {
        return this.mSerde.serialize(row, rowOI).toString();
    }

    @Override
    public void close() throws IOException {
    }
}

