/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.properties.PropertyMap;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.properties.SoftCache;

public class CachingPropertyStore
extends PropertyStore {
    protected final SoftCache<String, PropertyMap> maps;
    protected final PropertyStore store;

    public CachingPropertyStore(PropertyStore wrap) {
        this(wrap, new Configuration());
    }

    public CachingPropertyStore(PropertyStore wrap, Configuration conf) {
        this.store = wrap;
        int capacity = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.PROPERTIES_CACHE_CAPACITY);
        float fillFactor = (float)MetastoreConf.getDoubleVar(conf, MetastoreConf.ConfVars.PROPERTIES_CACHE_LOADFACTOR);
        this.maps = new SoftCache(capacity, fillFactor, false);
    }

    public void clearCache() {
        this.maps.clear();
    }

    @Override
    public UUID fetchDigest(String mapKey) {
        return this.store.fetchDigest(mapKey);
    }

    @Override
    public Map<String, UUID> selectDigest(String keyPrefix, Predicate<String> keyFilter) {
        return this.store.selectDigest(keyPrefix, keyFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyMap fetchProperties(String mapKey, Function<String, PropertySchema> getSchema) {
        CachingPropertyStore cachingPropertyStore = this;
        synchronized (cachingPropertyStore) {
            PropertyMap map = this.maps.compute(mapKey, this.mapsCompute(mapKey, getSchema));
            return map != null ? map.copy() : null;
        }
    }

    BiFunction<String, PropertyMap, PropertyMap> mapsCompute(String string, Function<String, PropertySchema> getSchema) {
        return (k, v) -> {
            PropertyMap map = v;
            if (map != null) {
                UUID digest = map.getDigest();
                UUID fetchedDigest = this.fetchDigest(string);
                if (fetchedDigest != null && !Objects.equals(digest, fetchedDigest)) {
                    map = null;
                }
            }
            if (map == null) {
                map = this.store.fetchProperties(string, getSchema);
            }
            return map;
        };
    }

    @Override
    public Map<String, PropertyMap> selectProperties(String keyPrefix, Predicate<String> keyFilter, Function<String, PropertySchema> getSchema) {
        TreeMap<String, PropertyMap> results = new TreeMap<String, PropertyMap>();
        Map<String, UUID> digests = this.store.selectDigest(keyPrefix, keyFilter);
        Iterator<Map.Entry<String, UUID>> idigest = digests.entrySet().iterator();
        while (idigest.hasNext()) {
            Map.Entry<String, UUID> entry = idigest.next();
            String key = entry.getKey();
            PropertyMap map = this.maps.get(key);
            if (map == null || !Objects.equals(map.getDigest(), entry.getValue())) continue;
            results.put(key, map.copy());
            idigest.remove();
        }
        Map<String, PropertyMap> selectedMaps = this.store.selectProperties(keyPrefix, digests::containsKey, getSchema);
        selectedMaps.forEach((k, v) -> {
            PropertyMap m4 = this.maps.putIfAbsent((String)k, (PropertyMap)v);
            results.put((String)k, m4 != null && m4.isDirty() ? m4 : v.copy());
        });
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProperties(String mapKey, PropertyMap map) {
        CachingPropertyStore cachingPropertyStore = this;
        synchronized (cachingPropertyStore) {
            this.store.saveProperties(mapKey, map);
            this.maps.put(mapKey, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean dropProperties(String mapKey) {
        CachingPropertyStore cachingPropertyStore = this;
        synchronized (cachingPropertyStore) {
            boolean b = this.store.dropProperties(mapKey);
            this.maps.clear();
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameProperties(String mapKey, String newKey) {
        CachingPropertyStore cachingPropertyStore = this;
        synchronized (cachingPropertyStore) {
            PropertyMap map;
            if (!this.maps.containsKey(newKey) && (map = this.maps.remove(mapKey)) != null) {
                this.maps.put(newKey, map);
                return true;
            }
            return false;
        }
    }
}

