/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.util.Slices;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Slice
implements Comparable<Slice> {
    private final byte[] data;
    private final int offset;
    private final int length;
    private int hash;

    public Slice(int length) {
        this.data = new byte[length];
        this.offset = 0;
        this.length = length;
    }

    public Slice(byte[] data) {
        Preconditions.checkNotNull(data, "array is null");
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    public Slice(byte[] data, int offset, int length) {
        Preconditions.checkNotNull(data, "array is null");
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public int length() {
        return this.length;
    }

    public byte[] getRawArray() {
        return this.data;
    }

    public int getRawOffset() {
        return this.offset;
    }

    public byte getByte(int index) {
        Preconditions.checkPositionIndexes(index, index + 1, this.length);
        return this.data[index += this.offset];
    }

    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    public short getShort(int index) {
        Preconditions.checkPositionIndexes(index, index + 2, this.length);
        return (short)(this.data[index += this.offset] & 0xFF | this.data[index + 1] << 8);
    }

    public int getInt(int index) {
        Preconditions.checkPositionIndexes(index, index + 4, this.length);
        return this.data[index += this.offset] & 0xFF | (this.data[index + 1] & 0xFF) << 8 | (this.data[index + 2] & 0xFF) << 16 | (this.data[index + 3] & 0xFF) << 24;
    }

    public long getLong(int index) {
        Preconditions.checkPositionIndexes(index, index + 8, this.length);
        return (long)this.data[index += this.offset] & 0xFFL | ((long)this.data[index + 1] & 0xFFL) << 8 | ((long)this.data[index + 2] & 0xFFL) << 16 | ((long)this.data[index + 3] & 0xFFL) << 24 | ((long)this.data[index + 4] & 0xFFL) << 32 | ((long)this.data[index + 5] & 0xFFL) << 40 | ((long)this.data[index + 6] & 0xFFL) << 48 | ((long)this.data[index + 7] & 0xFFL) << 56;
    }

    public void getBytes(int index, Slice dst, int dstIndex, int length) {
        this.getBytes(index, dst.data, dstIndex, length);
    }

    public void getBytes(int index, byte[] destination, int destinationIndex, int length) {
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        Preconditions.checkPositionIndexes(destinationIndex, destinationIndex + length, destination.length);
        System.arraycopy(this.data, index += this.offset, destination, destinationIndex, length);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.length);
    }

    public byte[] getBytes(int index, int length) {
        if ((index += this.offset) == 0) {
            return Arrays.copyOf(this.data, length);
        }
        byte[] value = new byte[length];
        System.arraycopy(this.data, index, value, 0, length);
        return value;
    }

    public void getBytes(int index, ByteBuffer destination) {
        Preconditions.checkPositionIndex(index, this.length);
        destination.put(this.data, index += this.offset, Math.min(this.length, destination.remaining()));
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        out.write(this.data, index += this.offset, length);
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        return out.write(ByteBuffer.wrap(this.data, index += this.offset, length));
    }

    public void setShort(int index, int value) {
        Preconditions.checkPositionIndexes(index, index + 2, this.length);
        this.data[index += this.offset] = (byte)value;
        this.data[index + 1] = (byte)(value >>> 8);
    }

    public void setInt(int index, int value) {
        Preconditions.checkPositionIndexes(index, index + 4, this.length);
        this.data[index += this.offset] = (byte)value;
        this.data[index + 1] = (byte)(value >>> 8);
        this.data[index + 2] = (byte)(value >>> 16);
        this.data[index + 3] = (byte)(value >>> 24);
    }

    public void setLong(int index, long value) {
        Preconditions.checkPositionIndexes(index, index + 8, this.length);
        this.data[index += this.offset] = (byte)value;
        this.data[index + 1] = (byte)(value >>> 8);
        this.data[index + 2] = (byte)(value >>> 16);
        this.data[index + 3] = (byte)(value >>> 24);
        this.data[index + 4] = (byte)(value >>> 32);
        this.data[index + 5] = (byte)(value >>> 40);
        this.data[index + 6] = (byte)(value >>> 48);
        this.data[index + 7] = (byte)(value >>> 56);
    }

    public void setByte(int index, int value) {
        Preconditions.checkPositionIndexes(index, index + 1, this.length);
        this.data[index += this.offset] = (byte)value;
    }

    public void setBytes(int index, Slice src, int srcIndex, int length) {
        this.setBytes(index, src.data, src.offset + srcIndex, length);
    }

    public void setBytes(int index, byte[] source, int sourceIndex, int length) {
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        Preconditions.checkPositionIndexes(sourceIndex, sourceIndex + length, source.length);
        System.arraycopy(source, sourceIndex, this.data, index += this.offset, length);
    }

    public void setBytes(int index, ByteBuffer source) {
        Preconditions.checkPositionIndexes(index, index + source.remaining(), this.length);
        source.get(this.data, index += this.offset, source.remaining());
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        int localReadBytes;
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        index += this.offset;
        int readBytes = 0;
        do {
            if ((localReadBytes = in.read(this.data, index, length)) < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            readBytes += localReadBytes;
            index += localReadBytes;
        } while ((length -= localReadBytes) > 0);
        return readBytes;
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        int localReadBytes;
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        ByteBuffer buf = ByteBuffer.wrap(this.data, index += this.offset, length);
        int readBytes = 0;
        do {
            try {
                localReadBytes = in.read(buf);
            }
            catch (ClosedChannelException e) {
                localReadBytes = -1;
            }
            if (localReadBytes >= 0) continue;
            if (readBytes != 0) break;
            return -1;
        } while (localReadBytes != 0 && (readBytes += localReadBytes) < length);
        return readBytes;
    }

    public int setBytes(int index, FileChannel in, int position, int length) throws IOException {
        int localReadBytes;
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        ByteBuffer buf = ByteBuffer.wrap(this.data, index += this.offset, length);
        int readBytes = 0;
        do {
            try {
                localReadBytes = in.read(buf, position + readBytes);
            }
            catch (ClosedChannelException e) {
                localReadBytes = -1;
            }
            if (localReadBytes >= 0) continue;
            if (readBytes != 0) break;
            return -1;
        } while (localReadBytes != 0 && (readBytes += localReadBytes) < length);
        return readBytes;
    }

    public Slice copySlice() {
        return this.copySlice(0, this.length);
    }

    public Slice copySlice(int index, int length) {
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.data, index += this.offset, copiedArray, 0, length);
        return new Slice(copiedArray);
    }

    public byte[] copyBytes() {
        return this.copyBytes(0, this.length);
    }

    public byte[] copyBytes(int index, int length) {
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        if ((index += this.offset) == 0) {
            return Arrays.copyOf(this.data, length);
        }
        byte[] value = new byte[length];
        System.arraycopy(this.data, index, value, 0, length);
        return value;
    }

    public Slice slice() {
        return this.slice(0, this.length);
    }

    public Slice slice(int index, int length) {
        if (index == 0 && length == this.length) {
            return this;
        }
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        if (index >= 0 && length == 0) {
            return Slices.EMPTY_SLICE;
        }
        return new Slice(this.data, this.offset + index, length);
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.length);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        Preconditions.checkPositionIndexes(index, index + length, this.length);
        return ByteBuffer.wrap(this.data, index += this.offset, length).order(ByteOrder.LITTLE_ENDIAN);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slice slice = (Slice)o;
        if (this.length != slice.length) {
            return false;
        }
        if (this.offset == slice.offset && this.data == slice.data) {
            return true;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.data[this.offset + i] == slice.data[slice.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int result = this.length;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            result = 31 * result + this.data[i];
        }
        if (result == 0) {
            result = 1;
        }
        this.hash = result;
        return this.hash;
    }

    @Override
    public int compareTo(Slice that) {
        if (this == that) {
            return 0;
        }
        if (this.data == that.data && this.length == that.length && this.offset == that.offset) {
            return 0;
        }
        int minLength = Math.min(this.length, that.length);
        for (int i = 0; i < minLength; ++i) {
            int thisByte = 0xFF & this.data[this.offset + i];
            int thatByte = 0xFF & that.data[that.offset + i];
            if (thisByte == thatByte) continue;
            return thisByte - thatByte;
        }
        return this.length - that.length;
    }

    public String toString(Charset charset) {
        return this.toString(0, this.length, charset);
    }

    public String toString(int index, int length, Charset charset) {
        if (length == 0) {
            return "";
        }
        return Slices.decodeString(this.toByteBuffer(index, length), charset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "length=" + this.length() + ')';
    }
}

