/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.DeleteTableResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class DeleteTableRequest
extends KuduRpc<DeleteTableResponse> {
    static final String DELETE_TABLE = "DeleteTable";
    private final String name;
    private int reserveSeconds = -1;

    DeleteTableRequest(KuduTable table, String name, Timer timer, long timeoutMillis, int reserveSeconds) {
        super(table, timer, timeoutMillis);
        this.name = name;
        this.reserveSeconds = reserveSeconds;
    }

    DeleteTableRequest(KuduTable table, String name, Timer timer, long timeoutMillis) {
        super(table, timer, timeoutMillis);
        this.name = name;
    }

    @Override
    Message createRequestPB() {
        Master.DeleteTableRequestPB.Builder builder = Master.DeleteTableRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        if (this.reserveSeconds >= 0) {
            builder.setReserveSeconds(this.reserveSeconds);
        }
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return DELETE_TABLE;
    }

    @Override
    Pair<DeleteTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.DeleteTableResponsePB.Builder builder = Master.DeleteTableResponsePB.newBuilder();
        DeleteTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        DeleteTableResponse response = new DeleteTableResponse(this.timeoutTracker.getElapsedMillis(), tsUUID);
        return new Pair<DeleteTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }
}

