/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Optional;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.launcher.LauncherInterceptor;
import org.junit.platform.launcher.core.ClasspathAlignmentChecker;

class ClasspathAlignmentCheckingLauncherInterceptor
implements LauncherInterceptor {
    static final LauncherInterceptor INSTANCE = new ClasspathAlignmentCheckingLauncherInterceptor();

    ClasspathAlignmentCheckingLauncherInterceptor() {
    }

    @Override
    public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
        try {
            return invocation.proceed();
        }
        catch (LinkageError e) {
            Optional<JUnitException> exception = ClasspathAlignmentChecker.check(e);
            if (exception.isPresent()) {
                throw exception.get();
            }
            throw e;
        }
    }

    @Override
    public void close() {
    }
}

