/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.catalog.CatalogDispatcher;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.catalog.PartitionDispatcher;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.catalog.TopicDispatcher;
import org.apache.gravitino.credential.CredentialOperationDispatcher;
import org.apache.gravitino.job.JobOperationDispatcher;
import org.apache.gravitino.lineage.LineageConfig;
import org.apache.gravitino.lineage.LineageDispatcher;
import org.apache.gravitino.lineage.LineageService;
import org.apache.gravitino.metalake.MetalakeDispatcher;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.policy.PolicyDispatcher;
import org.apache.gravitino.server.ServerConfig;
import org.apache.gravitino.server.authentication.ServerAuthenticator;
import org.apache.gravitino.server.authorization.GravitinoAuthorizerProvider;
import org.apache.gravitino.server.web.ConfigServlet;
import org.apache.gravitino.server.web.HttpServerMetricsSource;
import org.apache.gravitino.server.web.JettyServer;
import org.apache.gravitino.server.web.JettyServerConfig;
import org.apache.gravitino.server.web.ObjectMapperProvider;
import org.apache.gravitino.server.web.VersioningFilter;
import org.apache.gravitino.server.web.filter.AccessControlNotAllowedFilter;
import org.apache.gravitino.server.web.filter.GravitinoInterceptionService;
import org.apache.gravitino.server.web.mapper.JsonMappingExceptionMapper;
import org.apache.gravitino.server.web.mapper.JsonParseExceptionMapper;
import org.apache.gravitino.server.web.mapper.JsonProcessingExceptionMapper;
import org.apache.gravitino.server.web.ui.WebUIFilter;
import org.apache.gravitino.stats.StatisticDispatcher;
import org.apache.gravitino.tag.TagDispatcher;
import org.glassfish.hk2.api.InterceptionService;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoServer
extends ResourceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(GravitinoServer.class);
    private static final String API_ANY_PATH = "/api/*";
    public static final String CONF_FILE = "gravitino.conf";
    public static final String WEBSERVER_CONF_PREFIX = "gravitino.server.webserver.";
    public static final String SERVER_NAME = "Gravitino-webserver";
    private final ServerConfig serverConfig;
    private final JettyServer server;
    private final GravitinoEnv gravitinoEnv;
    private final LineageService lineageService;

    public GravitinoServer(ServerConfig config, GravitinoEnv gravitinoEnv) {
        this.serverConfig = config;
        this.server = new JettyServer();
        this.gravitinoEnv = gravitinoEnv;
        this.lineageService = new LineageService();
    }

    public void initialize() {
        this.gravitinoEnv.initializeFullComponents((Config)this.serverConfig);
        JettyServerConfig jettyServerConfig = JettyServerConfig.fromConfig((Config)this.serverConfig, (String)WEBSERVER_CONF_PREFIX);
        this.server.initialize(jettyServerConfig, SERVER_NAME, true);
        ServerAuthenticator.getInstance().initialize((Config)this.serverConfig);
        GravitinoAuthorizerProvider.getInstance().initialize(this.serverConfig);
        this.lineageService.initialize(new LineageConfig(this.serverConfig.getConfigsWithPrefix("gravitino.lineage.")));
        this.initializeRestApi();
    }

    public ServerConfig serverConfig() {
        return this.serverConfig;
    }

    private void initializeRestApi() {
        HashSet<String> restApiPackagesSet = new HashSet<String>();
        restApiPackagesSet.add("org.apache.gravitino.server.web.rest");
        restApiPackagesSet.addAll((Collection)this.serverConfig.get(Configs.REST_API_EXTENSION_PACKAGES));
        restApiPackagesSet.addAll(this.lineageService.getRESTPackages());
        this.packages(restApiPackagesSet.toArray(new String[0]));
        boolean enableAuthorization = (Boolean)this.serverConfig.get(Configs.ENABLE_AUTHORIZATION);
        this.register(new AbstractBinder(){

            protected void configure() {
                if (((Boolean)GravitinoServer.this.serverConfig.get(Configs.ENABLE_AUTHORIZATION)).booleanValue()) {
                    this.bind(GravitinoInterceptionService.class).to(InterceptionService.class).in(Singleton.class);
                }
                this.bind(GravitinoServer.this.gravitinoEnv.metalakeDispatcher()).to(MetalakeDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.catalogDispatcher()).to(CatalogDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.schemaDispatcher()).to(SchemaDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.tableDispatcher()).to(TableDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.partitionDispatcher()).to(PartitionDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.filesetDispatcher()).to(FilesetDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.topicDispatcher()).to(TopicDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.tagDispatcher()).to(TagDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.policyDispatcher()).to(PolicyDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.credentialOperationDispatcher()).to(CredentialOperationDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.modelDispatcher()).to(ModelDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.lineageService).to(LineageDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.jobOperationDispatcher()).to(JobOperationDispatcher.class).ranked(1);
                this.bind(GravitinoServer.this.gravitinoEnv.statisticDispatcher()).to(StatisticDispatcher.class).ranked(1);
            }
        });
        this.register(JsonProcessingExceptionMapper.class);
        this.register(JsonParseExceptionMapper.class);
        this.register(JsonMappingExceptionMapper.class);
        this.register(ObjectMapperProvider.class).register(JacksonFeature.class);
        this.property("jersey.config.json.jackson.disabled.modules", "DefaultScalaModule");
        if (!enableAuthorization) {
            this.register(AccessControlNotAllowedFilter.class);
        }
        HttpServerMetricsSource httpServerMetricsSource = new HttpServerMetricsSource("gravitino-server", (ResourceConfig)this, this.server);
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        metricsSystem.register((MetricsSource)httpServerMetricsSource);
        ServletContainer servlet = new ServletContainer((ResourceConfig)this);
        this.server.addServlet((Servlet)servlet, API_ANY_PATH);
        ConfigServlet configServlet = new ConfigServlet(this.serverConfig);
        this.server.addServlet((Servlet)configServlet, "/configs");
        this.server.addCustomFilters(API_ANY_PATH);
        this.server.addFilter((Filter)new VersioningFilter(), API_ANY_PATH);
        this.server.addSystemFilters(API_ANY_PATH);
        this.server.addFilter((Filter)new WebUIFilter(), "/");
        this.server.addFilter((Filter)new WebUIFilter(), "/ui/*");
    }

    public void start() throws Exception {
        this.gravitinoEnv.start();
        this.server.start();
    }

    public void join() {
        this.server.join();
    }

    public void stop() throws IOException {
        GravitinoAuthorizerProvider.getInstance().close();
        this.server.stop();
        this.gravitinoEnv.shutdown();
        if (this.lineageService != null) {
            this.lineageService.close();
        }
    }

    public static void main(String[] args) {
        LOG.info("Starting Gravitino Server");
        String confPath = System.getenv("GRAVITINO_TEST") == null ? "" : args[0];
        ServerConfig serverConfig = GravitinoServer.loadConfig(confPath);
        GravitinoServer server = new GravitinoServer(serverConfig, GravitinoEnv.getInstance());
        try {
            server.initialize();
            server.start();
        }
        catch (Exception e) {
            LOG.error("Error while running jettyServer", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Done, Gravitino server started.");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Thread.sleep(((Integer)server.serverConfig.get(ServerConfig.SERVER_SHUTDOWN_TIMEOUT)).intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Interrupted exception:", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Error while running clean-up tasks in shutdown hook", (Throwable)e);
            }
        }));
        server.join();
        LOG.info("Shutting down Gravitino Server ... ");
        try {
            server.stop();
            LOG.info("Gravitino Server has shut down.");
        }
        catch (Exception e) {
            LOG.error("Error while stopping Gravitino Server", (Throwable)e);
        }
    }

    static ServerConfig loadConfig(String confPath) {
        ServerConfig serverConfig = new ServerConfig();
        try {
            if (confPath.isEmpty()) {
                serverConfig.loadFromFile(CONF_FILE);
            } else {
                Properties properties = serverConfig.loadPropertiesFromFile(new File(confPath));
                serverConfig.loadFromProperties(properties);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to load conf from file " + confPath, exception);
        }
        return serverConfig;
    }
}

