/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

public class FileIOParser {
    private static final String FILE_IO_IMPL = "io-impl";
    private static final String PROPERTIES = "properties";

    private FileIOParser() {
    }

    public static String toJson(FileIO io) {
        return FileIOParser.toJson(io, false);
    }

    public static String toJson(FileIO io, boolean pretty) {
        return JsonUtil.generate(gen -> FileIOParser.toJson(io, gen), pretty);
    }

    public static void toJson(FileIO io, JsonGenerator generator) throws IOException {
        Map properties;
        String impl = io.getClass().getName();
        try {
            properties = io.properties();
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(String.format("Cannot serialize FileIO: %s does not expose configuration properties", impl));
        }
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (String)"Cannot serialize FileIO: invalid configuration properties (null)", (Object)impl);
        generator.writeStartObject();
        generator.writeStringField(FILE_IO_IMPL, impl);
        JsonUtil.writeStringMap(PROPERTIES, properties, generator);
        generator.writeEndObject();
    }

    public static FileIO fromJson(String json) {
        return FileIOParser.fromJson(json, null);
    }

    public static FileIO fromJson(String json, Object conf) {
        return JsonUtil.parse(json, node -> FileIOParser.fromJson(node, conf));
    }

    public static FileIO fromJson(JsonNode json, Object conf) {
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse FileIO from non-object: %s", (Object)json);
        String impl = JsonUtil.getString(FILE_IO_IMPL, json);
        Map<String, String> properties = JsonUtil.getStringMap(PROPERTIES, json);
        return CatalogUtil.loadFileIO(impl, properties, conf);
    }
}

