/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class Ciphers {
    public static final int PLAIN_BLOCK_SIZE = 0x100000;
    public static final int NONCE_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 16;
    public static final int CIPHER_BLOCK_SIZE = 0x10001C;
    public static final String GCM_STREAM_MAGIC_STRING = "AGS1";
    static final byte[] GCM_STREAM_MAGIC_ARRAY = "AGS1".getBytes(StandardCharsets.UTF_8);
    static final ByteBuffer GCM_STREAM_MAGIC = ByteBuffer.wrap(GCM_STREAM_MAGIC_ARRAY).asReadOnlyBuffer();
    static final int GCM_STREAM_HEADER_LENGTH = GCM_STREAM_MAGIC_ARRAY.length + 4;
    private static final int GCM_TAG_LENGTH_BITS = 128;
    static final int MIN_STREAM_LENGTH = GCM_STREAM_HEADER_LENGTH + 12 + 16;

    private Ciphers() {
    }

    private static SecretKeySpec newKey(byte[] keyBytes) {
        Preconditions.checkArgument((keyBytes != null ? 1 : 0) != 0, (Object)"Invalid key: null");
        int keyLength = keyBytes.length;
        Preconditions.checkArgument((keyLength == 16 || keyLength == 24 || keyLength == 32 ? 1 : 0) != 0, (String)"Invalid key length: %s (must be 16, 24, or 32 bytes)", (int)keyLength);
        return new SecretKeySpec(keyBytes, "AES");
    }

    private static Cipher newCipher() {
        try {
            return Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Failed to create GCM cipher", e);
        }
    }

    static byte[] streamBlockAAD(byte[] fileAadPrefix, int currentBlockIndex) {
        byte[] blockAAD = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(currentBlockIndex).array();
        if (null == fileAadPrefix) {
            return blockAAD;
        }
        byte[] aad = new byte[fileAadPrefix.length + 4];
        System.arraycopy(fileAadPrefix, 0, aad, 0, fileAadPrefix.length);
        System.arraycopy(blockAAD, 0, aad, fileAadPrefix.length, 4);
        return aad;
    }

    public static class AesGcmDecryptor {
        private final SecretKeySpec aesKey;
        private final Cipher cipher;

        public AesGcmDecryptor(byte[] keyBytes) {
            this.aesKey = Ciphers.newKey(keyBytes);
            this.cipher = Ciphers.newCipher();
        }

        public byte[] decrypt(byte[] ciphertext, byte[] aad) {
            return this.decrypt(ciphertext, 0, ciphertext.length, aad);
        }

        public byte[] decrypt(byte[] ciphertext, int ciphertextOffset, int ciphertextLength, byte[] aad) {
            int plaintextLength = ciphertextLength - 16 - 12;
            byte[] plaintext = new byte[plaintextLength];
            this.decrypt(ciphertext, ciphertextOffset, ciphertextLength, plaintext, 0, aad);
            return plaintext;
        }

        public int decrypt(byte[] ciphertext, int ciphertextOffset, int ciphertextLength, byte[] plaintextBuffer, int plaintextOffset, byte[] aad) {
            int plaintextLength;
            Preconditions.checkState((ciphertextLength - 16 - 12 >= 0 ? 1 : 0) != 0, (Object)("Cannot decrypt cipher text of length " + ciphertext.length + " because text must longer than GCM_TAG_LENGTH + NONCE_LENGTH bytes. Text may not be encrypted with AES GCM cipher"));
            try {
                GCMParameterSpec spec = new GCMParameterSpec(128, ciphertext, ciphertextOffset, 12);
                this.cipher.init(2, (Key)this.aesKey, spec);
                if (null != aad) {
                    this.cipher.updateAAD(aad);
                }
                plaintextLength = this.cipher.doFinal(ciphertext, ciphertextOffset + 12, ciphertextLength - 12, plaintextBuffer, plaintextOffset);
            }
            catch (AEADBadTagException e) {
                throw new RuntimeException("GCM tag check failed. Possible reasons: wrong decryption key; or corrupt/tampered data. AES GCM doesn't differentiate between these two.", e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Failed to decrypt", e);
            }
            return plaintextLength;
        }
    }

    public static class AesGcmEncryptor {
        private final SecretKeySpec aesKey;
        private final Cipher cipher;
        private final SecureRandom randomGenerator;
        private final byte[] nonce;

        public AesGcmEncryptor(byte[] keyBytes) {
            this.aesKey = Ciphers.newKey(keyBytes);
            this.cipher = Ciphers.newCipher();
            this.randomGenerator = new SecureRandom();
            this.nonce = new byte[12];
        }

        public byte[] encrypt(byte[] plaintext, byte[] aad) {
            return this.encrypt(plaintext, 0, plaintext.length, aad);
        }

        public byte[] encrypt(byte[] plaintext, int plaintextOffset, int plaintextLength, byte[] aad) {
            int cipherTextLength = 12 + plaintextLength + 16;
            byte[] cipherText = new byte[cipherTextLength];
            this.encrypt(plaintext, plaintextOffset, plaintextLength, cipherText, 0, aad);
            return cipherText;
        }

        public int encrypt(byte[] plaintext, int plaintextOffset, int plaintextLength, byte[] ciphertextBuffer, int ciphertextOffset, byte[] aad) {
            int enciphered;
            Preconditions.checkArgument((plaintextLength >= 0 ? 1 : 0) != 0, (String)"Invalid plain text length: %s", (int)plaintextLength);
            this.randomGenerator.nextBytes(this.nonce);
            try {
                GCMParameterSpec spec = new GCMParameterSpec(128, this.nonce);
                this.cipher.init(1, (Key)this.aesKey, spec);
                if (null != aad) {
                    this.cipher.updateAAD(aad);
                }
                if ((enciphered = this.cipher.doFinal(plaintext, plaintextOffset, plaintextLength, ciphertextBuffer, ciphertextOffset + 12)) != plaintextLength + 16) {
                    throw new RuntimeException("Failed to encrypt block: expected " + plaintextLength + "16 encrypted bytes but produced bytes " + enciphered);
                }
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Failed to encrypt", e);
            }
            System.arraycopy(this.nonce, 0, ciphertextBuffer, ciphertextOffset, 12);
            return enciphered + 12;
        }
    }
}

