/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.metalake;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.MetalakeInUseException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.metalake.MetalakeDispatcher;

public class MetalakeNormalizeDispatcher
implements MetalakeDispatcher {
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"system");
    private static final String METALAKE_NAME_PATTERN = "^\\w[\\w]{0,63}$";
    private final MetalakeDispatcher dispatcher;

    public MetalakeNormalizeDispatcher(MetalakeDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public Metalake[] listMetalakes() {
        return this.dispatcher.listMetalakes();
    }

    @Override
    public Metalake loadMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        return this.dispatcher.loadMetalake(ident);
    }

    @Override
    public boolean metalakeExists(NameIdentifier ident) {
        return this.dispatcher.metalakeExists(ident);
    }

    @Override
    public Metalake createMetalake(NameIdentifier ident, String comment, Map<String, String> properties) throws MetalakeAlreadyExistsException {
        this.validateMetalakeName(ident.name());
        PropertiesMetadataHelpers.validatePropertyForCreate(BaseMetalake.PROPERTIES_METADATA, properties);
        return this.dispatcher.createMetalake(ident, comment, properties);
    }

    @Override
    public Metalake alterMetalake(NameIdentifier ident, MetalakeChange ... changes) throws NoSuchMetalakeException, IllegalArgumentException {
        Arrays.stream(changes).forEach(change -> {
            if (change instanceof MetalakeChange.RenameMetalake) {
                this.validateMetalakeName(((MetalakeChange.RenameMetalake)change).getNewName());
            }
        });
        Pair<Map<String, String>, Map<String, String>> alterProperty = this.getMetalakeAlterProperty(changes);
        PropertiesMetadataHelpers.validatePropertyForAlter(BaseMetalake.PROPERTIES_METADATA, (Map)alterProperty.getLeft(), (Map)alterProperty.getRight());
        return this.dispatcher.alterMetalake(ident, changes);
    }

    @Override
    public boolean dropMetalake(NameIdentifier ident) {
        return this.dispatcher.dropMetalake(ident);
    }

    @Override
    public boolean dropMetalake(NameIdentifier ident, boolean force) throws NonEmptyEntityException, MetalakeInUseException {
        return this.dispatcher.dropMetalake(ident, force);
    }

    @Override
    public void enableMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        this.dispatcher.enableMetalake(ident);
    }

    @Override
    public void disableMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        this.dispatcher.disableMetalake(ident);
    }

    private void validateMetalakeName(String name) {
        if (RESERVED_WORDS.contains(name)) {
            throw new IllegalArgumentException("The metalake name '" + name + "' is reserved.");
        }
        if (!name.matches(METALAKE_NAME_PATTERN)) {
            throw new IllegalArgumentException("The metalake name '" + name + "' is illegal.");
        }
    }

    private Pair<Map<String, String>, Map<String, String>> getMetalakeAlterProperty(MetalakeChange ... metalakeChanges) {
        HashMap upserts = Maps.newHashMap();
        HashMap deletes = Maps.newHashMap();
        Arrays.stream(metalakeChanges).forEach(metalakeChange -> {
            if (metalakeChange instanceof MetalakeChange.SetProperty) {
                MetalakeChange.SetProperty setProperty = (MetalakeChange.SetProperty)metalakeChange;
                upserts.put(setProperty.getProperty(), setProperty.getValue());
            } else if (metalakeChange instanceof MetalakeChange.RemoveProperty) {
                MetalakeChange.RemoveProperty removeProperty = (MetalakeChange.RemoveProperty)metalakeChange;
                deletes.put(removeProperty.getProperty(), removeProperty.getProperty());
            }
        });
        return Pair.of((Object)upserts, (Object)deletes);
    }
}

