/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.utils.Preconditions;

@Public
public class MapType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "MAP<%s, %s>";
    private final DataType keyType;
    private final DataType valueType;

    public MapType(boolean isNullable, DataType keyType, DataType valueType) {
        super(isNullable, DataTypeRoot.MAP);
        this.keyType = Preconditions.checkNotNull(keyType, "Key type must not be null.");
        this.valueType = Preconditions.checkNotNull(valueType, "Value type must not be null.");
    }

    public MapType(DataType keyType, DataType valueType) {
        this(true, keyType, valueType);
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    @Override
    public int defaultSize() {
        return this.keyType.defaultSize() + this.valueType.defaultSize();
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new MapType(isNullable, this.keyType.copy(), this.valueType.copy());
    }

    public DataType newKeyValueType(DataType newKeyType, DataType newValueType) {
        return new MapType(this.isNullable(), newKeyType, newValueType);
    }

    @Override
    public String asSQLString() {
        return this.withNullability(FORMAT, this.keyType.asSQLString(), this.valueType.asSQLString());
    }

    @Override
    public void serializeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", this.isNullable() ? "MAP" : "MAP NOT NULL");
        generator.writeFieldName("key");
        this.keyType.serializeJson(generator);
        generator.writeFieldName("value");
        this.valueType.serializeJson(generator);
        generator.writeEndObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapType mapType = (MapType)o;
        return this.keyType.equals(mapType.keyType) && this.valueType.equals(mapType.valueType);
    }

    @Override
    public boolean equalsIgnoreFieldId(DataType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapType mapType = (MapType)o;
        return this.keyType.equalsIgnoreFieldId(mapType.keyType) && this.valueType.equalsIgnoreFieldId(mapType.valueType);
    }

    @Override
    public boolean isPrunedFrom(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapType mapType = (MapType)o;
        return this.keyType.isPrunedFrom(mapType.keyType) && this.valueType.isPrunedFrom(mapType.valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyType, this.valueType);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void collectFieldIds(Set<Integer> fieldIds) {
        this.keyType.collectFieldIds(fieldIds);
        this.valueType.collectFieldIds(fieldIds);
    }
}

