/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueManagementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;

public class GuaranteedOrZeroCapacityOverTimePolicy
implements AutoCreatedQueueManagementPolicy {
    private CapacitySchedulerContext scheduler;
    private ManagedParentQueue managedParentQueue;
    private static final Log LOG = LogFactory.getLog(GuaranteedOrZeroCapacityOverTimePolicy.class);
    private AutoCreatedLeafQueueConfig ZERO_CAPACITY_ENTITLEMENT;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private ReentrantReadWriteLock.ReadLock readLock;
    private ParentQueueState parentQueueState = new ParentQueueState();
    private AutoCreatedLeafQueueConfig leafQueueTemplate;
    private QueueCapacities leafQueueTemplateCapacities;
    private Map<String, LeafQueueState> leafQueueStateMap = new HashMap<String, LeafQueueState>();
    private Clock clock = new MonotonicClock();
    private PendingApplicationComparator applicationComparator = new PendingApplicationComparator();

    private boolean containsLeafQueue(String leafQueueName) {
        return this.leafQueueStateMap.containsKey(leafQueueName);
    }

    private boolean addLeafQueueStateIfNotExists(String leafQueueName, LeafQueueState leafQueueState) {
        if (!this.containsLeafQueue(leafQueueName)) {
            this.leafQueueStateMap.put(leafQueueName, leafQueueState);
            return true;
        }
        return false;
    }

    private boolean addLeafQueueStateIfNotExists(LeafQueue leafQueue) {
        return this.addLeafQueueStateIfNotExists(leafQueue.getQueueName(), new LeafQueueState());
    }

    private void clearLeafQueueState() {
        this.leafQueueStateMap.clear();
    }

    @Override
    public void init(CapacitySchedulerContext schedulerContext, ParentQueue parentQueue) {
        this.scheduler = schedulerContext;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IllegalArgumentException("Expected instance of type " + ManagedParentQueue.class);
        }
        this.managedParentQueue = (ManagedParentQueue)parentQueue;
        this.initializeLeafQueueTemplate(this.managedParentQueue);
        LOG.info((Object)("Initialized queue management policy for parent queue " + parentQueue.getQueueName() + " with leaf queue template capacities : [" + this.leafQueueTemplate.getQueueCapacities() + "]"));
    }

    private void initializeLeafQueueTemplate(ManagedParentQueue parentQueue) {
        this.leafQueueTemplate = parentQueue.getLeafQueueTemplate();
        this.leafQueueTemplateCapacities = this.leafQueueTemplate.getQueueCapacities();
        this.ZERO_CAPACITY_ENTITLEMENT = this.buildTemplate(0.0f, this.leafQueueTemplateCapacities.getMaximumCapacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueManagementChange> computeQueueManagementChanges() throws SchedulerDynamicEditException {
        this.updateLeafQueueState();
        try {
            List<FiCaSchedulerApp> pendingApps;
            this.readLock.lock();
            ArrayList<QueueManagementChange> queueManagementChanges = new ArrayList<QueueManagementChange>();
            float parentAbsoluteCapacity = this.managedParentQueue.getQueueCapacities().getAbsoluteCapacity();
            float leafQueueTemplateAbsoluteCapacity = this.leafQueueTemplateCapacities.getAbsoluteCapacity();
            Map<String, QueueCapacities> deactivatedLeafQueues = this.deactivateLeafQueuesIfInActive(this.managedParentQueue, queueManagementChanges);
            float deactivatedCapacity = this.getTotalDeactivatedCapacity(deactivatedLeafQueues);
            float sumOfChildQueueActivatedCapacity = this.parentQueueState.getAbsoluteActivatedChildQueueCapacity();
            float availableCapacity = this.getAvailableCapacity(parentAbsoluteCapacity, deactivatedCapacity, sumOfChildQueueActivatedCapacity);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parent queue : " + this.managedParentQueue.getQueueName() + " absCapacity = " + parentAbsoluteCapacity + ", leafQueueAbsoluteCapacity = " + leafQueueTemplateAbsoluteCapacity + ", deactivatedCapacity = " + deactivatedCapacity + " , absChildActivatedCapacity = " + sumOfChildQueueActivatedCapacity + ", availableCapacity = " + availableCapacity));
            }
            if (availableCapacity >= leafQueueTemplateAbsoluteCapacity && (pendingApps = this.getSortedPendingApplications()).size() > 0) {
                int maxLeafQueuesTobeActivated = this.getMaxLeavesToBeActivated(availableCapacity, leafQueueTemplateAbsoluteCapacity, pendingApps.size());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found " + maxLeafQueuesTobeActivated + " leaf queues to be activated with " + pendingApps.size() + " apps "));
                }
                LinkedHashSet<String> leafQueuesToBeActivated = this.getSortedLeafQueues(pendingApps, maxLeafQueuesTobeActivated, deactivatedLeafQueues.keySet());
                this.computeQueueManagementChanges(leafQueuesToBeActivated, queueManagementChanges, availableCapacity, leafQueueTemplateAbsoluteCapacity);
                if (LOG.isDebugEnabled() && leafQueuesToBeActivated.size() > 0) {
                    LOG.debug((Object)("Activated leaf queues : [" + leafQueuesToBeActivated + "]"));
                }
            }
            ArrayList<QueueManagementChange> arrayList = queueManagementChanges;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private float getTotalDeactivatedCapacity(Map<String, QueueCapacities> deactivatedLeafQueues) {
        float deactivatedCapacity = 0.0f;
        for (Map.Entry<String, QueueCapacities> deactivatedQueueCapacity : deactivatedLeafQueues.entrySet()) {
            deactivatedCapacity += deactivatedQueueCapacity.getValue().getAbsoluteCapacity();
        }
        return deactivatedCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateLeafQueueState() {
        try {
            this.writeLock.lock();
            HashSet<String> newQueues = new HashSet<String>();
            for (CSQueue newQueue : this.managedParentQueue.getChildQueues()) {
                if (!(newQueue instanceof LeafQueue)) continue;
                this.addLeafQueueStateIfNotExists((LeafQueue)newQueue);
                newQueues.add(newQueue.getQueueName());
            }
            Iterator<Map.Entry<String, LeafQueueState>> itr = this.leafQueueStateMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, LeafQueueState> e = itr.next();
                String queueName = e.getKey();
                if (newQueues.contains(queueName)) continue;
                itr.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private LinkedHashSet<String> getSortedLeafQueues(List<FiCaSchedulerApp> pendingApps, int leafQueuesNeeded, Set<String> deactivatedQueues) throws SchedulerDynamicEditException {
        LinkedHashSet<String> leafQueues = new LinkedHashSet<String>(leafQueuesNeeded);
        int ctr = 0;
        for (FiCaSchedulerApp app : pendingApps) {
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)app.getCSLeafQueue();
            String leafQueueName = leafQueue.getQueueName();
            if (ctr >= leafQueuesNeeded) break;
            if (this.isActive(leafQueue) || deactivatedQueues.contains(leafQueueName) || !this.addLeafQueueIfNotExists(leafQueues, leafQueueName)) continue;
            ++ctr;
        }
        return leafQueues;
    }

    private boolean addLeafQueueIfNotExists(Set<String> leafQueues, String leafQueueName) {
        boolean ret = false;
        if (!leafQueues.contains(leafQueueName)) {
            ret = leafQueues.add(leafQueueName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isActive(AutoCreatedLeafQueue leafQueue) throws SchedulerDynamicEditException {
        try {
            this.readLock.lock();
            LeafQueueState leafQueueStatus = this.getLeafQueueState(leafQueue);
            boolean bl = leafQueueStatus.isActive();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Map<String, QueueCapacities> deactivateLeafQueuesIfInActive(ParentQueue parentQueue, List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException {
        HashMap<String, QueueCapacities> deactivatedQueues = new HashMap<String, QueueCapacities>();
        for (CSQueue childQueue : parentQueue.getChildQueues()) {
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)childQueue;
            if (this.isActive(leafQueue) && !this.hasPendingApps(leafQueue)) {
                queueManagementChanges.add(new QueueManagementChange.UpdateQueue((CSQueue)leafQueue, this.ZERO_CAPACITY_ENTITLEMENT));
                deactivatedQueues.put(leafQueue.getQueueName(), this.leafQueueTemplateCapacities);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(" Leaf queue has pending applications :  " + leafQueue.getNumApplications() + ".Skipping deactivation for " + leafQueue));
        }
        if (LOG.isDebugEnabled() && deactivatedQueues.size() > 0) {
            LOG.debug((Object)("Deactivated leaf queues : " + deactivatedQueues));
        }
        return deactivatedQueues;
    }

    private void computeQueueManagementChanges(Set<String> leafQueuesToBeActivated, List<QueueManagementChange> queueManagementChanges, float availableCapacity, float leafQueueTemplateAbsoluteCapacity) {
        float curAvailableCapacity = availableCapacity;
        for (String curLeafQueue : leafQueuesToBeActivated) {
            if (!(curAvailableCapacity >= leafQueueTemplateAbsoluteCapacity)) continue;
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.scheduler.getCapacitySchedulerQueueManager().getQueue(curLeafQueue);
            if (leafQueue != null) {
                AutoCreatedLeafQueueConfig newTemplate = this.buildTemplate(this.leafQueueTemplateCapacities.getCapacity(), this.leafQueueTemplateCapacities.getMaximumCapacity());
                queueManagementChanges.add(new QueueManagementChange.UpdateQueue((CSQueue)leafQueue, newTemplate));
                curAvailableCapacity -= leafQueueTemplateAbsoluteCapacity;
                continue;
            }
            LOG.warn((Object)("Could not find queue in scheduler while trying to deactivate " + curLeafQueue));
        }
    }

    @VisibleForTesting
    public int getMaxLeavesToBeActivated(float availableCapacity, float childQueueAbsoluteCapacity, int numPendingApps) throws SchedulerDynamicEditException {
        if (childQueueAbsoluteCapacity > 0.0f) {
            int numLeafQueuesNeeded = (int)Math.floor(availableCapacity / childQueueAbsoluteCapacity);
            return Math.min(numLeafQueuesNeeded, numPendingApps);
        }
        throw new SchedulerDynamicEditException("Child queue absolute capacity is initialized to 0. Check parent queue's  " + this.managedParentQueue.getQueueName() + " leaf queue template configuration");
    }

    private float getAvailableCapacity(float parentAbsCapacity, float deactivatedAbsCapacity, float totalChildQueueActivatedCapacity) {
        return parentAbsCapacity - totalChildQueueActivatedCapacity + deactivatedAbsCapacity + 1.0E-4f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitQueueManagementChanges(List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            for (QueueManagementChange queueManagementChange : queueManagementChanges) {
                AutoCreatedLeafQueueConfig updatedQueueTemplate = queueManagementChange.getUpdatedQueueTemplate();
                CSQueue queue = queueManagementChange.getQueue();
                if (!(queue instanceof AutoCreatedLeafQueue)) {
                    throw new SchedulerDynamicEditException("Expected queue management change for AutoCreatedLeafQueue. Found " + queue.getClass().getName());
                }
                AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)queue;
                if (updatedQueueTemplate.getQueueCapacities().getCapacity() > 0.0f) {
                    if (this.isActive(leafQueue)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Queue is already active. Skipping activation : " + queue.getQueuePath()));
                        continue;
                    }
                    this.activate(leafQueue);
                    continue;
                }
                if (!this.isActive(leafQueue)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Queue is already de-activated. Skipping de-activation : " + leafQueue.getQueuePath()));
                    continue;
                }
                this.deactivate(leafQueue);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void activate(AutoCreatedLeafQueue leafQueue) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            this.getLeafQueueState(leafQueue).activate();
            this.parentQueueState.incAbsoluteActivatedChildCapacity("", this.leafQueueTemplateCapacities.getAbsoluteCapacity());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate(AutoCreatedLeafQueue leafQueue) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            this.getLeafQueueState(leafQueue).deactivate();
            for (String nodeLabel : this.managedParentQueue.getQueueCapacities().getExistingNodeLabels()) {
                this.parentQueueState.decAbsoluteActivatedChildCapacity(nodeLabel, this.leafQueueTemplateCapacities.getAbsoluteCapacity());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasPendingApps(AutoCreatedLeafQueue leafQueue) {
        return leafQueue.getNumApplications() > 0;
    }

    @Override
    public void reinitialize(CapacitySchedulerContext schedulerContext, ParentQueue parentQueue) {
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IllegalStateException("Expected instance of type " + ManagedParentQueue.class + " found   : " + parentQueue.getClass());
        }
        if (this.managedParentQueue != null && !parentQueue.getQueuePath().equals(this.managedParentQueue.getQueuePath())) {
            throw new IllegalStateException("Expected parent queue path to match " + this.managedParentQueue.getQueuePath() + " found : " + parentQueue.getQueuePath());
        }
        this.managedParentQueue = (ManagedParentQueue)parentQueue;
        this.initializeLeafQueueTemplate(this.managedParentQueue);
        this.parentQueueState.clear();
        this.clearLeafQueueState();
        LOG.info((Object)("Reinitialized queue management policy for parent queue " + parentQueue.getQueueName() + " with leaf queue template capacities : [" + this.leafQueueTemplate.getQueueCapacities() + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCreatedLeafQueueConfig getInitialLeafQueueConfiguration(AbstractAutoCreatedLeafQueue leafQueue) throws SchedulerDynamicEditException {
        if (!(leafQueue instanceof AutoCreatedLeafQueue)) {
            throw new SchedulerDynamicEditException("Not an instance of AutoCreatedLeafQueue : " + leafQueue.getClass());
        }
        AutoCreatedLeafQueue autoCreatedLeafQueue = (AutoCreatedLeafQueue)leafQueue;
        AutoCreatedLeafQueueConfig template = this.ZERO_CAPACITY_ENTITLEMENT;
        try {
            this.writeLock.lock();
            if (!this.addLeafQueueStateIfNotExists(leafQueue)) {
                LOG.error((Object)("Leaf queue already exists in state : " + this.getLeafQueueState(leafQueue)));
                throw new SchedulerDynamicEditException("Leaf queue already exists in state : " + this.getLeafQueueState(leafQueue));
            }
            float availableCapacity = this.getAvailableCapacity(this.managedParentQueue.getQueueCapacities().getAbsoluteCapacity(), 0.0f, this.parentQueueState.getAbsoluteActivatedChildQueueCapacity());
            if (availableCapacity >= this.leafQueueTemplateCapacities.getAbsoluteCapacity()) {
                this.activate(autoCreatedLeafQueue);
                template = this.buildTemplate(this.leafQueueTemplateCapacities.getCapacity(), this.leafQueueTemplateCapacities.getMaximumCapacity());
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    LeafQueueState getLeafQueueState(LeafQueue queue) throws SchedulerDynamicEditException {
        try {
            this.readLock.lock();
            String queueName = queue.getQueueName();
            if (!this.containsLeafQueue(queueName)) {
                throw new SchedulerDynamicEditException("Could not find leaf queue in state " + queueName);
            }
            LeafQueueState leafQueueState = this.leafQueueStateMap.get(queueName);
            return leafQueueState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public float getAbsoluteActivatedChildQueueCapacity() {
        return this.parentQueueState.getAbsoluteActivatedChildQueueCapacity();
    }

    private List<FiCaSchedulerApp> getSortedPendingApplications() {
        ArrayList<FiCaSchedulerApp> apps = new ArrayList<FiCaSchedulerApp>(this.managedParentQueue.getAllApplications());
        Collections.sort(apps, this.applicationComparator);
        return apps;
    }

    private AutoCreatedLeafQueueConfig buildTemplate(float capacity, float maxCapacity) {
        AutoCreatedLeafQueueConfig.Builder templateBuilder = new AutoCreatedLeafQueueConfig.Builder();
        QueueCapacities capacities = new QueueCapacities(false);
        templateBuilder.capacities(capacities);
        for (String nodeLabel : this.managedParentQueue.getQueueCapacities().getExistingNodeLabels()) {
            capacities.setCapacity(nodeLabel, capacity);
            capacities.setMaximumCapacity(nodeLabel, maxCapacity);
        }
        return new AutoCreatedLeafQueueConfig(templateBuilder);
    }

    private class PendingApplicationComparator
    implements Comparator<FiCaSchedulerApp> {
        private PendingApplicationComparator() {
        }

        @Override
        public int compare(FiCaSchedulerApp app1, FiCaSchedulerApp app2) {
            RMApp rmApp1 = (RMApp)GuaranteedOrZeroCapacityOverTimePolicy.this.scheduler.getRMContext().getRMApps().get(app1.getApplicationId());
            RMApp rmApp2 = (RMApp)GuaranteedOrZeroCapacityOverTimePolicy.this.scheduler.getRMContext().getRMApps().get(app2.getApplicationId());
            if (rmApp1 != null && rmApp2 != null) {
                return Long.compare(rmApp1.getSubmitTime(), rmApp2.getSubmitTime());
            }
            if (rmApp1 != null) {
                return -1;
            }
            if (rmApp2 != null) {
                return 1;
            }
            return 0;
        }
    }

    private class ParentQueueState {
        private Map<String, Float> totalAbsoluteActivatedChildQueueCapacityByLabel = new HashMap<String, Float>();

        private ParentQueueState() {
        }

        private float getAbsoluteActivatedChildQueueCapacity() {
            return this.getAbsoluteActivatedChildQueueCapacity("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float getAbsoluteActivatedChildQueueCapacity(String nodeLabel) {
            try {
                GuaranteedOrZeroCapacityOverTimePolicy.this.readLock.lock();
                Float totalActivatedCapacity = this.getByLabel(nodeLabel);
                if (totalActivatedCapacity != null) {
                    float f = totalActivatedCapacity.floatValue();
                    return f;
                }
                float f = 0.0f;
                return f;
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incAbsoluteActivatedChildCapacity(String nodeLabel, float childQueueCapacity) {
            try {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.lock();
                Float activatedChildCapacity = this.getByLabel(nodeLabel);
                if (activatedChildCapacity != null) {
                    this.setByLabel(nodeLabel, activatedChildCapacity.floatValue() + childQueueCapacity);
                } else {
                    this.setByLabel(nodeLabel, childQueueCapacity);
                }
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decAbsoluteActivatedChildCapacity(String nodeLabel, float childQueueCapacity) {
            try {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.lock();
                Float activatedChildCapacity = this.getByLabel(nodeLabel);
                if (activatedChildCapacity != null) {
                    this.setByLabel(nodeLabel, activatedChildCapacity.floatValue() - childQueueCapacity);
                } else {
                    this.setByLabel(nodeLabel, childQueueCapacity);
                }
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.unlock();
            }
        }

        Float getByLabel(String label) {
            return this.totalAbsoluteActivatedChildQueueCapacityByLabel.get(label);
        }

        Float setByLabel(String label, float val) {
            return this.totalAbsoluteActivatedChildQueueCapacityByLabel.put(label, Float.valueOf(val));
        }

        void clear() {
            this.totalAbsoluteActivatedChildQueueCapacityByLabel.clear();
        }
    }

    private class LeafQueueState {
        private AtomicBoolean isActive = new AtomicBoolean(false);
        private long mostRecentActivationTime;
        private long mostRecentDeactivationTime;

        private LeafQueueState() {
        }

        public long getMostRecentActivationTime() {
            return this.mostRecentActivationTime;
        }

        public long getMostRecentDeactivationTime() {
            return this.mostRecentDeactivationTime;
        }

        public boolean isActive() {
            return this.isActive.get();
        }

        private boolean activate() {
            boolean ret = this.isActive.compareAndSet(false, true);
            this.mostRecentActivationTime = GuaranteedOrZeroCapacityOverTimePolicy.this.clock.getTime();
            return ret;
        }

        private boolean deactivate() {
            boolean ret = this.isActive.compareAndSet(true, false);
            this.mostRecentDeactivationTime = GuaranteedOrZeroCapacityOverTimePolicy.this.clock.getTime();
            return ret;
        }
    }
}

