/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.nio.ByteOrder;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.spdy.SpdySettingsFrame;
import org.jboss.netty.handler.codec.spdy.SpdyVersion;

public class SpdyFrameEncoder {
    private final int version;

    public SpdyFrameEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        this.version = spdyVersion.getVersion();
    }

    private void writeControlFrameHeader(ChannelBuffer buffer, int type, byte flags, int length) {
        buffer.writeShort(this.version | 0x8000);
        buffer.writeShort(type);
        buffer.writeByte(flags);
        buffer.writeMedium(length);
    }

    public ChannelBuffer encodeDataFrame(int streamId, boolean last, ChannelBuffer data) {
        int flags = last ? 1 : 0;
        ChannelBuffer header = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8);
        header.writeInt(streamId & Integer.MAX_VALUE);
        header.writeByte(flags);
        header.writeMedium(data.readableBytes());
        return ChannelBuffers.wrappedBuffer(header, data);
    }

    public ChannelBuffer encodeSynStreamFrame(int streamId, int associatedToStreamId, byte priority, boolean last, boolean unidirectional, ChannelBuffer headerBlock) {
        byte flags;
        byte by = flags = last ? (byte)1 : 0;
        if (unidirectional) {
            flags = (byte)(flags | 2);
        }
        int length = 10 + headerBlock.readableBytes();
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 18);
        this.writeControlFrameHeader(frame, 1, flags, length);
        frame.writeInt(streamId);
        frame.writeInt(associatedToStreamId);
        frame.writeShort((priority & 0xFF) << 13);
        return ChannelBuffers.wrappedBuffer(frame, headerBlock);
    }

    public ChannelBuffer encodeSynReplyFrame(int streamId, boolean last, ChannelBuffer headerBlock) {
        byte flags = last ? (byte)1 : 0;
        int length = 4 + headerBlock.readableBytes();
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 12);
        this.writeControlFrameHeader(frame, 2, flags, length);
        frame.writeInt(streamId);
        return ChannelBuffers.wrappedBuffer(frame, headerBlock);
    }

    public ChannelBuffer encodeRstStreamFrame(int streamId, int statusCode) {
        byte flags = 0;
        int length = 8;
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
        this.writeControlFrameHeader(frame, 3, flags, length);
        frame.writeInt(streamId);
        frame.writeInt(statusCode);
        return frame;
    }

    public ChannelBuffer encodeSettingsFrame(SpdySettingsFrame spdySettingsFrame) {
        Set<Integer> ids = spdySettingsFrame.getIds();
        int numSettings = ids.size();
        byte flags = spdySettingsFrame.clearPreviouslyPersistedSettings() ? (byte)1 : 0;
        int length = 4 + 8 * numSettings;
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
        this.writeControlFrameHeader(frame, 4, flags, length);
        frame.writeInt(numSettings);
        for (Integer id : ids) {
            flags = 0;
            if (spdySettingsFrame.isPersistValue(id)) {
                flags = (byte)(flags | 1);
            }
            if (spdySettingsFrame.isPersisted(id)) {
                flags = (byte)(flags | 2);
            }
            frame.writeByte(flags);
            frame.writeMedium(id);
            frame.writeInt(spdySettingsFrame.getValue(id));
        }
        return frame;
    }

    public ChannelBuffer encodePingFrame(int id) {
        byte flags = 0;
        int length = 4;
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
        this.writeControlFrameHeader(frame, 6, flags, length);
        frame.writeInt(id);
        return frame;
    }

    public ChannelBuffer encodeGoAwayFrame(int lastGoodStreamId, int statusCode) {
        byte flags = 0;
        int length = 8;
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
        this.writeControlFrameHeader(frame, 7, flags, length);
        frame.writeInt(lastGoodStreamId);
        frame.writeInt(statusCode);
        return frame;
    }

    public ChannelBuffer encodeHeadersFrame(int streamId, boolean last, ChannelBuffer headerBlock) {
        byte flags = last ? (byte)1 : 0;
        int length = 4 + headerBlock.readableBytes();
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 12);
        this.writeControlFrameHeader(frame, 8, flags, length);
        frame.writeInt(streamId);
        return ChannelBuffers.wrappedBuffer(frame, headerBlock);
    }

    public ChannelBuffer encodeWindowUpdateFrame(int streamId, int deltaWindowSize) {
        byte flags = 0;
        int length = 8;
        ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
        this.writeControlFrameHeader(frame, 9, flags, length);
        frame.writeInt(streamId);
        frame.writeInt(deltaWindowSize);
        return frame;
    }
}

