/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Catalog;
import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.cli.utils.FullNameUtil;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TagAlreadyAssociatedException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.rel.Table;

public class TagEntity
extends Command {
    protected final String metalake;
    protected final FullName name;
    protected final String[] tags;

    public TagEntity(CommandContext context, String metalake, FullName name, String[] tags) {
        super(context);
        this.metalake = metalake;
        this.name = name;
        this.tags = tags;
    }

    @Override
    public void handle() {
        String entity = "unknown";
        CharSequence[] tagsToAdd = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            if (this.name.getLevel() == 3) {
                String catalog = this.name.getCatalogName();
                Catalog catalogObject = client.loadCatalog(catalog);
                switch (catalogObject.type()) {
                    case RELATIONAL: {
                        String table;
                        entity = table = this.name.getTableName();
                        Table gTable = catalogObject.asTableCatalog().loadTable(FullNameUtil.toTable(this.name));
                        tagsToAdd = gTable.supportsTags().associateTags(this.tags, null);
                        break;
                    }
                    case MODEL: {
                        String model;
                        entity = model = this.name.getModelName();
                        Model gModel = catalogObject.asModelCatalog().getModel(FullNameUtil.toModel(this.name));
                        tagsToAdd = gModel.supportsTags().associateTags(this.tags, null);
                        break;
                    }
                    case FILESET: {
                        String fileset;
                        entity = fileset = this.name.getFilesetName();
                        Fileset gFileset = catalogObject.asFilesetCatalog().loadFileset(FullNameUtil.toFileset(this.name));
                        tagsToAdd = gFileset.supportsTags().associateTags(this.tags, null);
                        break;
                    }
                    case MESSAGING: {
                        String topic;
                        entity = topic = this.name.getTopicName();
                        Topic gTopic = catalogObject.asTopicCatalog().loadTopic(FullNameUtil.toTopic(this.name));
                        tagsToAdd = gTopic.supportsTags().associateTags(this.tags, null);
                        break;
                    }
                }
            } else if (this.name.hasSchemaName()) {
                String catalog = this.name.getCatalogName();
                String schema = this.name.getSchemaName();
                Schema gSchema = client.loadCatalog(catalog).asSchemas().loadSchema(schema);
                tagsToAdd = gSchema.supportsTags().associateTags(this.tags, null);
                entity = schema;
            } else if (this.name.hasCatalogName()) {
                String catalog = this.name.getCatalogName();
                Catalog gCatalog = client.loadCatalog(catalog);
                tagsToAdd = gCatalog.supportsTags().associateTags(this.tags, null);
                entity = catalog;
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (TagAlreadyAssociatedException err) {
            this.exitWithError("Tags are already associated with " + this.name.getName());
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        String all = tagsToAdd.length == 0 ? "nothing" : String.join((CharSequence)",", tagsToAdd);
        this.printInformation(entity + " now tagged with " + all);
    }

    @Override
    public Command validate() {
        if (this.name == null || !this.name.hasName().booleanValue()) {
            this.exitWithError("Missing --name option.");
        }
        return super.validate();
    }
}

