/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gravitino.cli.CommandActions;
import org.apache.gravitino.cli.CommandEntities;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.GravitinoOptions;

public class Main {
    public static boolean useExit = true;

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = new GravitinoOptions().options();
        if (args.length == 0) {
            GravitinoCommandLine.displayHelp(options);
            return;
        }
        try {
            CommandLine line = parser.parse(options, args);
            String entity = Main.resolveEntity(line);
            String[] extra = line.getArgs();
            if (extra.length > 2) {
                System.err.println("Too many arguments.");
                Main.exit(-1);
            }
            String command = Main.resolveCommand(line);
            GravitinoCommandLine commandLine = new GravitinoCommandLine(line, options, entity, command);
            if (entity != null && command != null) {
                commandLine.handleCommandLine();
            } else {
                commandLine.handleSimpleLine();
            }
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            GravitinoCommandLine.displayHelp(options);
            Main.exit(-1);
        }
    }

    public static void exit(int code) {
        if (!useExit) {
            throw new RuntimeException("Exit with code " + code);
        }
        System.exit(code);
    }

    protected static String resolveCommand(CommandLine line) {
        String[] args = line.getArgs();
        if (args.length == 2) {
            String action = args[1].toLowerCase(Locale.ENGLISH);
            if (CommandActions.isValidCommand(action)) {
                return action;
            }
        } else {
            if (args.length == 1) {
                return line.hasOption("help") ? "help" : "details";
            }
            if (args.length == 0) {
                return null;
            }
        }
        System.err.println("Unsupported or unknown command.");
        Main.exit(-1);
        return null;
    }

    protected static String resolveEntity(CommandLine line) {
        String[] args = line.getArgs();
        if (args.length >= 1) {
            String entity = args[0].toLowerCase(Locale.ENGLISH);
            if (CommandEntities.isValidEntity(entity)) {
                return entity;
            }
            System.err.println("Unknown entity.");
            Main.exit(-1);
        }
        return null;
    }
}

