/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.converter;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.hive.HiveSchema;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;

public class HiveDatabaseConverter {
    public static HiveSchema fromHiveDB(Database db) {
        Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"Database cannot be null");
        Map<String, String> properties = HiveDatabaseConverter.buildSchemaProperties(db);
        AuditInfo.Builder auditInfoBuilder = AuditInfo.builder();
        Optional.ofNullable(db.getOwnerName()).ifPresent(arg_0 -> ((AuditInfo.Builder)auditInfoBuilder).withCreator(arg_0));
        String catalogName = null;
        try {
            Method getCatalogNameMethod = db.getClass().getMethod("getCatalogName", new Class[0]);
            catalogName = (String)getCatalogNameMethod.invoke((Object)db, new Object[0]);
        }
        catch (Exception getCatalogNameMethod) {
            // empty catch block
        }
        HiveSchema hiveSchema = (HiveSchema)((HiveSchema.Builder)((HiveSchema.Builder)((HiveSchema.Builder)((HiveSchema.Builder)HiveSchema.builder().withName(db.getName())).withComment(db.getDescription())).withProperties(properties)).withAuditInfo(auditInfoBuilder.build())).withCatalogName(catalogName).build();
        return hiveSchema;
    }

    public static Map<String, String> buildSchemaProperties(Database database) {
        HashMap<String, String> properties = new HashMap<String, String>(database.getParameters());
        properties.put("location", database.getLocationUri());
        return properties;
    }

    public static Database toHiveDb(HiveSchema hiveSchema) {
        Preconditions.checkArgument((hiveSchema != null ? 1 : 0) != 0, (Object)"HiveSchema cannot be null");
        Database hiveDb = new Database();
        hiveDb.setName(hiveSchema.name());
        Optional.ofNullable((String)hiveSchema.properties().get("location")).ifPresent(arg_0 -> ((Database)hiveDb).setLocationUri(arg_0));
        Optional.ofNullable(hiveSchema.comment()).ifPresent(arg_0 -> ((Database)hiveDb).setDescription(arg_0));
        hiveDb.setOwnerName(hiveSchema.auditInfo().creator());
        hiveDb.setOwnerType(PrincipalType.USER);
        HashMap parameters = new HashMap(hiveSchema.properties());
        parameters.remove("location");
        hiveDb.setParameters(parameters);
        return hiveDb;
    }
}

