/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
public class BlockInfoContiguous
extends BlockInfo {
    public BlockInfoContiguous(short size) {
        super(size);
    }

    public BlockInfoContiguous(Block blk, short size) {
        super(blk, size);
    }

    private int ensureCapacity(int num) {
        assert (this.storages != null) : "BlockInfo is not initialized";
        int last = this.numNodes();
        if (this.storages.length >= last + num) {
            return last;
        }
        DatanodeStorageInfo[] old = this.storages;
        this.storages = new DatanodeStorageInfo[last + num];
        System.arraycopy(old, 0, this.storages, 0, last);
        return last;
    }

    @Override
    boolean addStorage(DatanodeStorageInfo storage, Block reportedBlock) {
        Preconditions.checkArgument((this.getBlockId() == reportedBlock.getBlockId() ? 1 : 0) != 0, (String)"reported blk_%s is different from stored blk_%s", (long)reportedBlock.getBlockId(), (long)this.getBlockId());
        int lastNode = this.ensureCapacity(1);
        this.setStorageInfo(lastNode, storage);
        return true;
    }

    @Override
    boolean removeStorage(DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return false;
        }
        int lastNode = this.numNodes() - 1;
        this.setStorageInfo(dnIndex, this.getStorageInfo(lastNode));
        this.setStorageInfo(lastNode, null);
        return true;
    }

    @Override
    boolean isProvided() {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo storage = this.getStorageInfo(idx);
            if (storage == null || !storage.getStorageType().equals((Object)StorageType.PROVIDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int numNodes() {
        assert (this.storages != null) : "BlockInfo is not initialized";
        for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
            if (this.getDatanode(idx) == null) continue;
            return idx + 1;
        }
        return 0;
    }

    @Override
    public final boolean isStriped() {
        return false;
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.CONTIGUOUS;
    }

    @Override
    final boolean hasNoStorage() {
        return this.getStorageInfo(0) == null;
    }
}

