/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.lakehouse.paimon.GravitinoPaimonColumn;
import org.apache.gravitino.catalog.lakehouse.paimon.GravitinoPaimonTable;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonCatalogPropertiesMetadata;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonSchema;
import org.apache.gravitino.catalog.lakehouse.paimon.ops.PaimonCatalogOps;
import org.apache.gravitino.catalog.lakehouse.paimon.utils.TableOpsUtils;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.utils.ClassLoaderResourceCleanerUtils;
import org.apache.gravitino.utils.MapUtils;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TableCatalog {
    public static final Logger LOG = LoggerFactory.getLogger(PaimonCatalogOperations.class);
    @VisibleForTesting
    public PaimonCatalogOps paimonCatalogOps;
    private static final String NO_SUCH_SCHEMA_EXCEPTION = "Paimon schema (database) %s does not exist.";
    private static final String NON_EMPTY_SCHEMA_EXCEPTION = "Paimon schema (database) %s is not empty. One or more tables exist.";
    private static final String SCHEMA_ALREADY_EXISTS_EXCEPTION = "Paimon schema (database) %s already exists.";
    private static final String NO_SUCH_TABLE_EXCEPTION = "Paimon table %s does not exist.";
    private static final String TABLE_ALREADY_EXISTS_EXCEPTION = "Paimon table %s already exists.";
    private static final String NO_SUCH_COLUMN_EXCEPTION = "Paimon column of table %s does not exist.";

    public void initialize(Map<String, String> conf, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        Map prefixMap = MapUtils.getPrefixMap(conf, (String)"gravitino.bypass.");
        Map<String, String> gravitinoConfig = ((PaimonCatalogPropertiesMetadata)propertiesMetadata.catalogPropertiesMetadata()).transformProperties(conf);
        HashMap resultConf = Maps.newHashMap((Map)prefixMap);
        resultConf.putAll(gravitinoConfig);
        this.paimonCatalogOps = new PaimonCatalogOps(new PaimonConfig(resultConf));
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        return (NameIdentifier[])this.paimonCatalogOps.listDatabases().stream().distinct().map(paimonNamespace -> NameIdentifier.of((Namespace)namespace, (String)paimonNamespace)).toArray(NameIdentifier[]::new);
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        try {
            this.paimonCatalogOps.listDatabases();
        }
        catch (Exception e) {
            throw new ConnectionFailedException((Throwable)e, "Failed to run listDatabases on Paimon catalog: %s", new Object[]{e.getMessage()});
        }
    }

    public PaimonSchema createSchema(NameIdentifier identifier, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        String currentUser = PaimonCatalogOperations.currentUser();
        PaimonSchema createdSchema = (PaimonSchema)((PaimonSchema.Builder)((PaimonSchema.Builder)((PaimonSchema.Builder)((PaimonSchema.Builder)PaimonSchema.builder().withName(identifier.name())).withComment(comment)).withProperties(properties)).withAuditInfo(AuditInfo.builder().withCreator(currentUser).withCreateTime(Instant.now()).build())).build();
        try {
            Map<String, String> paimonSchemaProperties = createdSchema.toPaimonProperties();
            this.paimonCatalogOps.createDatabase(identifier.name(), paimonSchemaProperties);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new SchemaAlreadyExistsException((Throwable)e, SCHEMA_ALREADY_EXISTS_EXCEPTION, new Object[]{identifier});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info("Created Paimon schema (database): {}. Current user: {}. Comment: {}. Metadata: {}.", new Object[]{identifier, currentUser, comment, properties});
        return createdSchema;
    }

    public PaimonSchema loadSchema(NameIdentifier identifier) throws NoSuchSchemaException {
        Map<String, String> properties;
        try {
            properties = this.paimonCatalogOps.loadDatabase(identifier.name());
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchSchemaException((Throwable)e, NO_SUCH_SCHEMA_EXCEPTION, new Object[]{identifier});
        }
        LOG.info("Loaded Paimon schema (database) {}.", (Object)identifier);
        return PaimonSchema.fromPaimonProperties(identifier.name(), properties);
    }

    public PaimonSchema alterSchema(NameIdentifier identifier, SchemaChange ... changes) throws NoSuchSchemaException {
        throw new UnsupportedOperationException("AlterSchema is unsupported now for Paimon Catalog.");
    }

    public boolean dropSchema(NameIdentifier identifier, boolean cascade) throws NonEmptySchemaException {
        try {
            this.paimonCatalogOps.dropDatabase(identifier.name(), cascade);
        }
        catch (Catalog.DatabaseNotExistException e) {
            LOG.warn("Paimon schema (database) {} does not exist.", (Object)identifier);
            return false;
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new NonEmptySchemaException((Throwable)e, NON_EMPTY_SCHEMA_EXCEPTION, new Object[]{identifier});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info("Dropped Paimon schema (database) {}.", (Object)identifier);
        return true;
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        List<String> tables;
        String[] levels = namespace.levels();
        NameIdentifier schemaIdentifier = NameIdentifier.of((String[])new String[]{levels[levels.length - 1]});
        try {
            tables = this.paimonCatalogOps.listTables(schemaIdentifier.name());
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchSchemaException((Throwable)e, NO_SUCH_SCHEMA_EXCEPTION, new Object[]{namespace.toString()});
        }
        return (NameIdentifier[])tables.stream().map(tableIdentifier -> NameIdentifier.of((String[])((String[])ArrayUtils.add((Object[])namespace.levels(), (Object)tableIdentifier)))).toArray(NameIdentifier[]::new);
    }

    public GravitinoPaimonTable loadTable(NameIdentifier identifier) throws NoSuchTableException {
        Table table;
        try {
            NameIdentifier tableIdentifier = this.buildPaimonNameIdentifier(identifier);
            table = this.paimonCatalogOps.loadTable(tableIdentifier.toString());
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException((Throwable)e, NO_SUCH_TABLE_EXCEPTION, new Object[]{identifier});
        }
        LOG.info("Loaded Paimon table {}.", (Object)identifier);
        return GravitinoPaimonTable.fromPaimonTable(table);
    }

    public GravitinoPaimonTable createTable(NameIdentifier identifier, Column[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        NameIdentifier nameIdentifier = this.buildPaimonNameIdentifier(identifier);
        NameIdentifier schemaIdentifier = NameIdentifier.of((String[])nameIdentifier.namespace().levels());
        if (!this.schemaExists(schemaIdentifier)) {
            throw new NoSuchSchemaException(NO_SUCH_SCHEMA_EXCEPTION, new Object[]{schemaIdentifier});
        }
        if (partitioning == null) {
            partitioning = Transforms.EMPTY_TRANSFORM;
        }
        if (indexes == null) {
            indexes = Indexes.EMPTY_INDEXES;
        }
        Preconditions.checkArgument((boolean)Arrays.stream(partitioning).allMatch(partition -> {
            NamedReference[] references = partition.references();
            return references.length == 1 && references[0] instanceof NamedReference.FieldReference;
        }), (Object)"Paimon partition columns should not be nested.");
        Preconditions.checkArgument((distribution == null || distribution.strategy() == Distributions.NONE.strategy() ? 1 : 0) != 0, (Object)"Distribution is not supported for Paimon in Gravitino now.");
        Preconditions.checkArgument((sortOrders == null || sortOrders.length == 0 ? 1 : 0) != 0, (Object)"Sort orders are not supported for Paimon in Gravitino.");
        this.checkPaimonIndexes(indexes);
        String currentUser = PaimonCatalogOperations.currentUser();
        GravitinoPaimonTable createdTable = (GravitinoPaimonTable)((GravitinoPaimonTable.Builder)((GravitinoPaimonTable.Builder)((GravitinoPaimonTable.Builder)((GravitinoPaimonTable.Builder)((GravitinoPaimonTable.Builder)((GravitinoPaimonTable.Builder)((GravitinoPaimonTable.Builder)GravitinoPaimonTable.builder().withName(identifier.name())).withColumns((Column[])Arrays.stream(columns).map(column -> {
            TableOpsUtils.checkColumnCapability(column.name(), column.defaultValue(), column.autoIncrement());
            return (GravitinoPaimonColumn)((GravitinoPaimonColumn.Builder)((GravitinoPaimonColumn.Builder)((GravitinoPaimonColumn.Builder)((GravitinoPaimonColumn.Builder)((GravitinoPaimonColumn.Builder)((GravitinoPaimonColumn.Builder)GravitinoPaimonColumn.builder().withName(column.name())).withType(column.dataType())).withComment(column.comment())).withNullable(column.nullable())).withAutoIncrement(column.autoIncrement())).withDefaultValue(column.defaultValue())).build();
        }).toArray(GravitinoPaimonColumn[]::new))).withPartitioning(partitioning)).withComment(comment)).withProperties(properties)).withIndexes(indexes)).withAuditInfo(AuditInfo.builder().withCreator(currentUser).withCreateTime(Instant.now()).build())).build();
        try {
            Schema paimonTableSchema = createdTable.toPaimonTableSchema();
            this.paimonCatalogOps.createTable(nameIdentifier.toString(), paimonTableSchema);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchSchemaException((Throwable)e, NO_SUCH_SCHEMA_EXCEPTION, new Object[]{identifier});
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistsException((Throwable)e, TABLE_ALREADY_EXISTS_EXCEPTION, new Object[]{identifier});
        }
        LOG.info("Created Paimon table: {}. Current user: {}. Comment: {}. Metadata: {}.", new Object[]{identifier, currentUser, comment, properties});
        return createdTable;
    }

    public GravitinoPaimonTable alterTable(NameIdentifier identifier, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        Optional<TableChange> renameTableOpt = Arrays.stream(changes).filter(tableChange -> tableChange instanceof TableChange.RenameTable).reduce((a, b) -> b);
        if (renameTableOpt.isPresent()) {
            String otherChanges = Arrays.stream(changes).filter(tableChange -> !(tableChange instanceof TableChange.RenameTable)).map(String::valueOf).collect(Collectors.joining("\n"));
            Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)otherChanges), (Object)String.format("The operation to change the table name cannot be performed together with other operations. The list of operations that you cannot perform includes: \n%s", otherChanges));
            return this.renameTable(identifier, (TableChange.RenameTable)renameTableOpt.get());
        }
        return this.internalAlterTable(identifier, changes);
    }

    public boolean dropTable(NameIdentifier identifier) {
        throw new UnsupportedOperationException("Paimon dropTable will both remove the metadata and data, please use purgeTable instead in Gravitino.");
    }

    public boolean purgeTable(NameIdentifier identifier) throws UnsupportedOperationException {
        try {
            NameIdentifier tableIdentifier = this.buildPaimonNameIdentifier(identifier);
            this.paimonCatalogOps.purgeTable(tableIdentifier.toString());
        }
        catch (Catalog.TableNotExistException e) {
            LOG.warn("Paimon table {} does not exist.", (Object)identifier);
            return false;
        }
        LOG.info("Purged Paimon table {}.", (Object)identifier);
        return true;
    }

    public void close() {
        if (this.paimonCatalogOps != null) {
            try {
                this.paimonCatalogOps.close();
                ClassLoaderResourceCleanerUtils.closeClassLoaderResource((ClassLoader)this.getClass().getClassLoader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String currentUser() {
        return PrincipalUtils.getCurrentUserName();
    }

    private NameIdentifier buildPaimonNameIdentifier(NameIdentifier identifier) {
        Preconditions.checkArgument((identifier != null && identifier.namespace() != null && identifier.namespace().levels().length > 0 ? 1 : 0) != 0, (Object)"Namespace can not be null or empty.");
        String[] levels = identifier.namespace().levels();
        return NameIdentifier.of((String[])new String[]{levels[levels.length - 1], identifier.name()});
    }

    private void checkPaimonIndexes(Index[] indexes) {
        Preconditions.checkArgument((indexes.length <= 1 ? 1 : 0) != 0, (Object)"Paimon supports no more than one Index.");
        Arrays.stream(indexes).forEach(index -> Preconditions.checkArgument((index.type() == Index.IndexType.PRIMARY_KEY ? 1 : 0) != 0, (Object)"Paimon only supports primary key Index."));
    }

    private GravitinoPaimonTable renameTable(NameIdentifier identifier, TableChange.RenameTable renameTable) throws NoSuchTableException, IllegalArgumentException {
        NameIdentifier newNnameIdentifier = NameIdentifier.of((Namespace)identifier.namespace(), (String)renameTable.getNewName());
        NameIdentifier oldIdentifier = this.buildPaimonNameIdentifier(identifier);
        NameIdentifier newIdentifier = this.buildPaimonNameIdentifier(newNnameIdentifier);
        try {
            this.paimonCatalogOps.renameTable(oldIdentifier.toString(), newIdentifier.toString());
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException((Throwable)e, NO_SUCH_TABLE_EXCEPTION, new Object[]{oldIdentifier});
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistsException((Throwable)e, TABLE_ALREADY_EXISTS_EXCEPTION, new Object[]{newIdentifier});
        }
        return this.loadTable(newNnameIdentifier);
    }

    private GravitinoPaimonTable internalAlterTable(NameIdentifier identifier, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        NameIdentifier paimonNameIdentifier = this.buildPaimonNameIdentifier(identifier);
        try {
            this.paimonCatalogOps.alterTable(paimonNameIdentifier.toString(), changes);
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException((Throwable)e, NO_SUCH_TABLE_EXCEPTION, new Object[]{paimonNameIdentifier});
        }
        catch (Catalog.ColumnNotExistException e) {
            throw new NoSuchColumnException((Throwable)e, NO_SUCH_COLUMN_EXCEPTION, new Object[]{paimonNameIdentifier});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.loadTable(identifier);
    }
}

