/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.client;

import java.util.List;
import java.util.Properties;
import org.apache.gravitino.hive.HivePartition;
import org.apache.gravitino.hive.HiveSchema;
import org.apache.gravitino.hive.HiveTable;
import org.apache.gravitino.hive.client.HiveClientClassLoader;
import org.apache.gravitino.hive.client.HiveExceptionConverter;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.thrift.TException;

public abstract class HiveShim {
    protected static final String RETRYING_META_STORE_CLIENT_CLASS = "org.apache.hadoop.hive.metastore.RetryingMetaStoreClient";
    protected static final String HIVE_CONF_CLASS = "org.apache.hadoop.hive.conf.HiveConf";
    protected static final String CONFIGURATION_CLASS = "org.apache.hadoop.conf.Configuration";
    protected static final String METHOD_GET_PROXY = "getProxy";
    protected final IMetaStoreClient client;
    protected final HiveClientClassLoader.HiveVersion version;

    protected HiveShim(HiveClientClassLoader.HiveVersion version, Properties properties) {
        this.client = this.createMetaStoreClient(properties);
        this.version = version;
    }

    public abstract IMetaStoreClient createMetaStoreClient(Properties var1);

    public List<String> getAllDatabases(String catalogName) {
        try {
            return this.client.getAllDatabases();
        }
        catch (TException e) {
            throw HiveExceptionConverter.toGravitinoException((Exception)((Object)e), HiveExceptionConverter.ExceptionTarget.catalog(catalogName));
        }
    }

    public abstract void createDatabase(HiveSchema var1);

    public abstract HiveSchema getDatabase(String var1, String var2);

    public abstract void alterDatabase(String var1, String var2, HiveSchema var3);

    public abstract void dropDatabase(String var1, String var2, boolean var3);

    public abstract List<String> getAllTables(String var1, String var2);

    public abstract List<String> listTableNamesByFilter(String var1, String var2, String var3, short var4);

    public abstract HiveTable getTable(String var1, String var2, String var3);

    public abstract void alterTable(String var1, String var2, String var3, HiveTable var4);

    public abstract void dropTable(String var1, String var2, String var3, boolean var4, boolean var5);

    public abstract void createTable(HiveTable var1);

    public abstract List<String> listPartitionNames(HiveTable var1, short var2);

    public abstract List<HivePartition> listPartitions(HiveTable var1, short var2);

    public abstract List<HivePartition> listPartitions(HiveTable var1, List<String> var2, short var3);

    public abstract HivePartition getPartition(HiveTable var1, String var2);

    public abstract HivePartition addPartition(HiveTable var1, HivePartition var2);

    public abstract void dropPartition(String var1, String var2, String var3, String var4, boolean var5);

    public abstract String getDelegationToken(String var1, String var2);

    public abstract List<HiveTable> getTableObjectsByName(String var1, String var2, List<String> var3);

    public abstract List<String> getCatalogs();

    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }
}

