/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.bitmap;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.fileindex.bitmap.BitmapTypeVisitor;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;

public class BitmapFileIndexMeta {
    protected final DataType dataType;
    protected final Options options;
    protected int rowCount;
    protected int nonNullBitmapNumber;
    protected boolean hasNullValue;
    protected int nullValueOffset;
    protected LinkedHashMap<Object, Integer> bitmapOffsets;
    protected Map<Object, Integer> bitmapLengths;
    protected long bodyStart;

    public BitmapFileIndexMeta(DataType dataType, Options options) {
        this.dataType = dataType;
        this.options = options;
    }

    public BitmapFileIndexMeta(DataType dataType, Options options, int rowCount, int nonNullBitmapNumber, boolean hasNullValue, int nullValueOffset, LinkedHashMap<Object, Integer> bitmapOffsets) {
        this(dataType, options);
        this.rowCount = rowCount;
        this.nonNullBitmapNumber = nonNullBitmapNumber;
        this.hasNullValue = hasNullValue;
        this.nullValueOffset = nullValueOffset;
        this.bitmapOffsets = bitmapOffsets;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public long getBodyStart() {
        return this.bodyStart;
    }

    public Entry findEntry(Object bitmapId) {
        int length;
        int n = length = this.bitmapLengths == null ? -1 : this.bitmapLengths.getOrDefault(bitmapId, -1);
        if (bitmapId == null) {
            if (this.hasNullValue) {
                return new Entry(null, this.nullValueOffset, length);
            }
        } else if (this.bitmapOffsets.containsKey(bitmapId)) {
            return new Entry(bitmapId, this.bitmapOffsets.get(bitmapId), length);
        }
        return null;
    }

    public void serialize(DataOutput out) throws Exception {
        ThrowableConsumer valueWriter = this.getValueWriter(out);
        out.writeInt(this.rowCount);
        out.writeInt(this.nonNullBitmapNumber);
        out.writeBoolean(this.hasNullValue);
        if (this.hasNullValue) {
            out.writeInt(this.nullValueOffset);
        }
        for (Map.Entry<Object, Integer> entry : this.bitmapOffsets.entrySet()) {
            valueWriter.accept(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    public void deserialize(SeekableInputStream seekableInputStream) throws Exception {
        this.bodyStart = seekableInputStream.getPos();
        BufferedInputStream inputStream = new BufferedInputStream(seekableInputStream);
        this.bitmapLengths = new HashMap<Object, Integer>();
        DataInputStream in = new DataInputStream(inputStream);
        ThrowableSupplier valueReader = this.getValueReader(in);
        Function<Object, Integer> measure = this.getSerializeSizeMeasure();
        this.rowCount = in.readInt();
        this.bodyStart += 4L;
        this.nonNullBitmapNumber = in.readInt();
        this.bodyStart += 4L;
        this.hasNullValue = in.readBoolean();
        ++this.bodyStart;
        if (this.hasNullValue) {
            this.nullValueOffset = in.readInt();
            this.bodyStart += 4L;
        }
        this.bitmapOffsets = new LinkedHashMap();
        Object lastValue = null;
        int lastOffset = this.nullValueOffset;
        for (int i = 0; i < this.nonNullBitmapNumber; ++i) {
            Object value = valueReader.get();
            int offset = in.readInt();
            this.bitmapOffsets.put(value, offset);
            this.bodyStart += (long)(measure.apply(value) + 4);
            if (offset < 0) continue;
            if (lastOffset >= 0) {
                int length = offset - lastOffset;
                this.bitmapLengths.put(lastValue, length);
            }
            lastValue = value;
            lastOffset = offset;
        }
    }

    protected Function<Object, Integer> getSerializeSizeMeasure() {
        return (Function)this.dataType.accept((DataTypeVisitor)new BitmapTypeVisitor<Function<Object, Integer>>(){

            @Override
            public Function<Object, Integer> visitBinaryString() {
                return o -> 4 + ((BinaryString)o).getSizeInBytes();
            }

            @Override
            public Function<Object, Integer> visitByte() {
                return o -> 1;
            }

            @Override
            public Function<Object, Integer> visitShort() {
                return o -> 2;
            }

            @Override
            public Function<Object, Integer> visitInt() {
                return o -> 4;
            }

            @Override
            public Function<Object, Integer> visitLong() {
                return o -> 8;
            }

            @Override
            public Function<Object, Integer> visitFloat() {
                return o -> 4;
            }

            @Override
            public Function<Object, Integer> visitDouble() {
                return o -> 8;
            }

            @Override
            public Function<Object, Integer> visitBoolean() {
                return o -> 1;
            }
        });
    }

    protected ThrowableConsumer getValueWriter(final DataOutput out) {
        return (ThrowableConsumer)this.dataType.accept((DataTypeVisitor)new BitmapTypeVisitor<ThrowableConsumer>(){

            @Override
            public ThrowableConsumer visitBinaryString() {
                return o -> {
                    byte[] bytes = ((BinaryString)o).toBytes();
                    out.writeInt(bytes.length);
                    out.write(bytes);
                };
            }

            @Override
            public ThrowableConsumer visitByte() {
                return o -> out.writeByte(((Byte)o).byteValue());
            }

            @Override
            public ThrowableConsumer visitShort() {
                return o -> out.writeShort(((Short)o).shortValue());
            }

            @Override
            public ThrowableConsumer visitInt() {
                return o -> out.writeInt((Integer)o);
            }

            @Override
            public ThrowableConsumer visitLong() {
                return o -> out.writeLong((Long)o);
            }

            @Override
            public ThrowableConsumer visitFloat() {
                return o -> out.writeFloat(((Float)o).floatValue());
            }

            @Override
            public ThrowableConsumer visitDouble() {
                return o -> out.writeDouble((Double)o);
            }

            @Override
            public ThrowableConsumer visitBoolean() {
                return o -> out.writeBoolean((Boolean)o);
            }
        });
    }

    protected ThrowableSupplier getValueReader(final DataInput in) {
        return (ThrowableSupplier)this.dataType.accept((DataTypeVisitor)new BitmapTypeVisitor<ThrowableSupplier>(){

            @Override
            public ThrowableSupplier visitBinaryString() {
                return () -> {
                    int length = in.readInt();
                    byte[] bytes = new byte[length];
                    in.readFully(bytes);
                    return BinaryString.fromBytes(bytes);
                };
            }

            @Override
            public ThrowableSupplier visitByte() {
                return in::readByte;
            }

            @Override
            public ThrowableSupplier visitShort() {
                return in::readShort;
            }

            @Override
            public ThrowableSupplier visitInt() {
                return in::readInt;
            }

            @Override
            public ThrowableSupplier visitLong() {
                return in::readLong;
            }

            @Override
            public ThrowableSupplier visitFloat() {
                return in::readFloat;
            }

            @Override
            public ThrowableSupplier visitDouble() {
                return in::readDouble;
            }

            @Override
            public ThrowableSupplier visitBoolean() {
                return in::readBoolean;
            }
        });
    }

    public static class Entry {
        Object key;
        int offset;
        int length;

        public Entry(Object key, int offset, int length) {
            this.key = key;
            this.offset = offset;
            this.length = length;
        }
    }

    public static interface ThrowableSupplier {
        public Object get() throws Exception;
    }

    public static interface ThrowableConsumer {
        public void accept(Object var1) throws Exception;
    }
}

