/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.utils.DateTimeUtils;

public class TimestampSerializer
implements Serializer<Timestamp> {
    private static final long serialVersionUID = 1L;
    private final int precision;

    public TimestampSerializer(int precision) {
        this.precision = precision;
    }

    @Override
    public Serializer<Timestamp> duplicate() {
        return new TimestampSerializer(this.precision);
    }

    @Override
    public Timestamp copy(Timestamp from) {
        return from;
    }

    @Override
    public void serialize(Timestamp record, DataOutputView target) throws IOException {
        if (Timestamp.isCompact(this.precision)) {
            assert (record.getNanoOfMillisecond() == 0);
            target.writeLong(record.getMillisecond());
        } else {
            target.writeLong(record.getMillisecond());
            target.writeInt(record.getNanoOfMillisecond());
        }
    }

    @Override
    public Timestamp deserialize(DataInputView source) throws IOException {
        if (Timestamp.isCompact(this.precision)) {
            long val = source.readLong();
            return Timestamp.fromEpochMillis(val);
        }
        long longVal = source.readLong();
        int intVal = source.readInt();
        return Timestamp.fromEpochMillis(longVal, intVal);
    }

    @Override
    public String serializeToString(Timestamp record) {
        return DateTimeUtils.formatTimestamp(record, this.precision);
    }

    @Override
    public Timestamp deserializeFromString(String s) {
        return DateTimeUtils.parseTimestampData(s, this.precision);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampSerializer that = (TimestampSerializer)obj;
        return this.precision == that.precision;
    }

    public int hashCode() {
        return this.precision;
    }
}

