/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import java.util.Arrays;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergColumn;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergTable;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.IcebergDataTypeConverter;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.ToIcebergType;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.ToIcebergTypeVisitor;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;

public class ConvertUtil {
    public static Schema toIcebergSchema(IcebergTable gravitinoTable) {
        Types.StructType gravitinoStructType = ConvertUtil.toGravitinoStructType(gravitinoTable);
        org.apache.iceberg.types.Type converted = ToIcebergTypeVisitor.visit((Type)gravitinoStructType, new ToIcebergType(gravitinoStructType));
        return new Schema(converted.asNestedType().asStructType().fields());
    }

    public static IcebergColumn fromNestedField(Types.NestedField nestedField) {
        return (IcebergColumn)((IcebergColumn.Builder)((IcebergColumn.Builder)((IcebergColumn.Builder)((IcebergColumn.Builder)IcebergColumn.builder().withName(nestedField.name())).withNullable(nestedField.isOptional())).withComment(nestedField.doc())).withType(IcebergDataTypeConverter.CONVERTER.toGravitino(nestedField.type()))).build();
    }

    private static Types.StructType toGravitinoStructType(IcebergTable icebergTable) {
        Types.StructType.Field[] fields = (Types.StructType.Field[])Arrays.stream(icebergTable.columns()).map(column -> Types.StructType.Field.of((String)column.name(), (Type)column.dataType(), (boolean)column.nullable(), (String)column.comment())).toArray(Types.StructType.Field[]::new);
        return Types.StructType.of((Types.StructType.Field[])fields);
    }

    private ConvertUtil() {
    }
}

