/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.exceptions.UnauthorizedException;
import org.apache.gravitino.server.authentication.Authenticator;
import org.apache.gravitino.server.authentication.OAuthConfig;
import org.apache.gravitino.server.authentication.OAuthTokenValidator;
import org.apache.gravitino.server.authentication.OAuthTokenValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2TokenAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2TokenAuthenticator.class);
    private String serviceAudience;
    private OAuthTokenValidator tokenValidator;

    OAuth2TokenAuthenticator() {
    }

    @Override
    public boolean isDataFromToken() {
        return true;
    }

    @Override
    public void initialize(Config config) throws RuntimeException {
        this.serviceAudience = (String)config.get(OAuthConfig.SERVICE_AUDIENCE);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.serviceAudience), (Object)"Service audience cannot be blank for OAuth authentication");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)config.get(OAuthConfig.DEFAULT_TOKEN_PATH))), (Object)"The path for token of the default OAuth server can't be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)config.get(OAuthConfig.DEFAULT_SERVER_URI))), (Object)"The uri of the default OAuth server can't be blank");
        this.tokenValidator = OAuthTokenValidatorFactory.createValidator(config);
    }

    @Override
    public Principal authenticateToken(byte[] tokenData) {
        if (tokenData == null) {
            LOG.warn("Empty token authorization header");
            throw new UnauthorizedException("Empty token authorization header", new Object[0]);
        }
        String authData = new String(tokenData, StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)authData) || !authData.startsWith("Bearer ")) {
            LOG.warn("Invalid token authorization header format");
            throw new UnauthorizedException("Invalid token authorization header", new Object[0]);
        }
        String token = authData.substring("Bearer ".length());
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new UnauthorizedException("Blank token found", new Object[0]);
        }
        try {
            return this.tokenValidator.validateToken(token, this.serviceAudience);
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("JWT parse error: {}", (Object)e.getMessage(), (Object)e);
            throw new UnauthorizedException((Throwable)e, "JWT parse error", new Object[0]);
        }
    }

    @Override
    public boolean supportsToken(byte[] tokenData) {
        return tokenData != null && new String(tokenData, StandardCharsets.UTF_8).startsWith("Bearer ");
    }
}

