/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.SnapshotManager;

public class ContinuousFromSnapshotFullStartingScanner
extends ReadPlanStartingScanner {
    public ContinuousFromSnapshotFullStartingScanner(SnapshotManager snapshotManager, long snapshotId) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotId;
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null) {
            return null;
        }
        long ceiledSnapshotId = Math.max(this.startingSnapshotId, earliestSnapshotId);
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(ceiledSnapshotId);
    }
}

