/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;

@Public
public class RawFile {
    private final String path;
    private final long fileSize;
    private final long offset;
    private final long length;
    private final String format;
    private final long schemaId;
    private final long rowCount;

    public RawFile(String path, long fileSize, long offset, long length, String format, long schemaId, long rowCount) {
        this.path = path;
        this.fileSize = fileSize;
        this.offset = offset;
        this.length = length;
        this.format = format;
        this.schemaId = schemaId;
        this.rowCount = rowCount;
    }

    public String path() {
        return this.path;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long offset() {
        return this.offset;
    }

    public long length() {
        return this.length;
    }

    public String format() {
        return this.format;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public long rowCount() {
        return this.rowCount;
    }

    public void serialize(DataOutputView out) throws IOException {
        out.writeUTF(this.path);
        out.writeLong(this.fileSize);
        out.writeLong(this.offset);
        out.writeLong(this.length);
        out.writeUTF(this.format);
        out.writeLong(this.schemaId);
        out.writeLong(this.rowCount);
    }

    public static RawFile deserialize(DataInputView in) throws IOException {
        String path = in.readUTF();
        long fileSize = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        String format = in.readUTF();
        long schemaId = in.readLong();
        long rowCount = in.readLong();
        return new RawFile(path, fileSize, offset, length, format, schemaId, rowCount);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RawFile)) {
            return false;
        }
        RawFile other = (RawFile)o;
        return Objects.equals(this.path, other.path) && this.fileSize == other.fileSize && this.offset == other.offset && this.length == other.length && Objects.equals(this.format, other.format) && this.schemaId == other.schemaId && this.rowCount == other.rowCount;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.fileSize, this.offset, this.length, this.format, this.schemaId, this.rowCount);
    }

    public String toString() {
        return String.format("{path = %s, offset = %d, offset = %d, length = %d, format = %s, schemaId = %d, rowCount = %d}", this.path, this.fileSize, this.offset, this.length, this.format, this.schemaId, this.rowCount);
    }
}

