/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.utils.JsonSerdeUtil;

public class ServiceManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVICE_PREFIX = "service-";
    public static final String PRIMARY_KEY_LOOKUP = "primary-key-lookup";
    private final FileIO fileIO;
    private final Path tablePath;

    public ServiceManager(FileIO fileIO, Path tablePath) {
        this.fileIO = fileIO;
        this.tablePath = tablePath;
    }

    public Path tablePath() {
        return this.tablePath;
    }

    public Optional<InetSocketAddress[]> service(String id) {
        try {
            return this.fileIO.readOverwrittenFileUtf8(this.servicePath(id)).map(s -> (InetSocketAddress[])JsonSerdeUtil.fromJson((String)s, InetSocketAddress[].class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void resetService(String id, InetSocketAddress[] addresses) {
        try {
            this.fileIO.overwriteFileUtf8(this.servicePath(id), JsonSerdeUtil.toJson((Object)addresses));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void deleteService(String id) {
        this.fileIO.deleteQuietly(this.servicePath(id));
    }

    private Path servicePath(String id) {
        return new Path(this.tablePath + "/service/" + SERVICE_PREFIX + id);
    }
}

