/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.table.sink.CommitMessage;

public class ManifestCommittable {
    private final long identifier;
    @Nullable
    private final Long watermark;
    private final Map<Integer, Long> logOffsets;
    private final Map<String, String> properties;
    private final List<CommitMessage> commitMessages;

    public ManifestCommittable(long identifier) {
        this(identifier, null);
    }

    public ManifestCommittable(long identifier, @Nullable Long watermark) {
        this.identifier = identifier;
        this.watermark = watermark;
        this.logOffsets = new HashMap<Integer, Long>();
        this.commitMessages = new ArrayList<CommitMessage>();
        this.properties = new HashMap<String, String>();
    }

    public ManifestCommittable(long identifier, @Nullable Long watermark, Map<Integer, Long> logOffsets, List<CommitMessage> commitMessages) {
        this(identifier, watermark, logOffsets, commitMessages, new HashMap<String, String>());
    }

    public ManifestCommittable(long identifier, @Nullable Long watermark, Map<Integer, Long> logOffsets, List<CommitMessage> commitMessages, Map<String, String> properties) {
        this.identifier = identifier;
        this.watermark = watermark;
        this.logOffsets = logOffsets;
        this.commitMessages = commitMessages;
        this.properties = properties;
    }

    public void addFileCommittable(CommitMessage commitMessage) {
        this.commitMessages.add(commitMessage);
    }

    public void addLogOffset(int bucket, long offset, boolean allowDuplicate) {
        if (!allowDuplicate && this.logOffsets.containsKey(bucket)) {
            throw new RuntimeException(String.format("bucket-%d appears multiple times, which is not possible.", bucket));
        }
        long newOffset = Math.max(this.logOffsets.getOrDefault(bucket, offset), offset);
        this.logOffsets.put(bucket, newOffset);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public long identifier() {
        return this.identifier;
    }

    @Nullable
    public Long watermark() {
        return this.watermark;
    }

    public Map<Integer, Long> logOffsets() {
        return this.logOffsets;
    }

    public List<CommitMessage> fileCommittables() {
        return this.commitMessages;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestCommittable that = (ManifestCommittable)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.watermark, that.watermark) && Objects.equals(this.logOffsets, that.logOffsets) && Objects.equals(this.commitMessages, that.commitMessages) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.watermark, this.logOffsets, this.commitMessages, this.properties);
    }

    public String toString() {
        return String.format("ManifestCommittable {identifier = %s, watermark = %s, logOffsets = %s, commitMessages = %s, properties = %s}", this.identifier, this.watermark, this.logOffsets, this.commitMessages, this.properties);
    }
}

