/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.partitioner;

import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.connector.source.abilities.SupportsLookupCustomShuffle;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.util.Preconditions;

public class RowDataCustomStreamPartitioner
extends StreamPartitioner<RowData> {
    private final SupportsLookupCustomShuffle.InputDataPartitioner partitioner;
    private final RowDataKeySelector keySelector;

    public RowDataCustomStreamPartitioner(SupportsLookupCustomShuffle.InputDataPartitioner partitioner, RowDataKeySelector keySelector) {
        this.partitioner = partitioner;
        this.keySelector = keySelector;
    }

    public int selectChannel(SerializationDelegate<StreamRecord<RowData>> record) {
        RowData key;
        try {
            key = (RowData)this.keySelector.getKey((RowData)((StreamRecord)record.getInstance()).getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract key from " + String.valueOf(((StreamRecord)record.getInstance()).getValue()), e);
        }
        int partition = this.partitioner.partition(key, this.numberOfChannels);
        Preconditions.checkState((partition < this.numberOfChannels ? 1 : 0) != 0, (Object)"The partition computed by custom partitioner is out of range, please check the logic of custom partitioner.");
        return partition;
    }

    public StreamPartitioner<RowData> copy() {
        return this;
    }

    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return SubtaskStateMapper.ARBITRARY;
    }

    public boolean isPointwise() {
        return false;
    }

    public String toString() {
        return "CUSTOM";
    }
}

