/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class ProcTimeUnboundedPrecedingFunction<K>
extends KeyedProcessFunction<K, RowData, RowData> {
    private static final long serialVersionUID = 2L;
    private final StateTtlConfig ttlConfig;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private transient AggsHandleFunction function;
    private transient ValueState<RowData> accState;
    private transient JoinedRowData output;

    public ProcTimeUnboundedPrecedingFunction(StateTtlConfig ttlConfig, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes) {
        this.ttlConfig = ttlConfig;
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
    }

    public void open(OpenContext openContext) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("accState", accTypeInfo);
        if (this.ttlConfig.isEnabled()) {
            stateDescriptor.enableTimeToLive(this.ttlConfig);
        }
        this.accState = this.getRuntimeContext().getState(stateDescriptor);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        RowData accumulators = (RowData)this.accState.value();
        if (null == accumulators) {
            accumulators = this.function.createAccumulators();
        }
        this.function.setAccumulators(accumulators);
        this.function.accumulate(input);
        accumulators = this.function.getAccumulators();
        this.accState.update((Object)accumulators);
        RowData aggValue = this.function.getValue();
        this.output.replace(input, aggValue);
        out.collect((Object)this.output);
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

