/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.stream.IntStream;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.LongHashJoinGenerator;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.plan.utils.SorMergeJoinOperatorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.HashJoinOperator;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class HashJoinOperatorUtil {
    public static StreamOperatorFactory<RowData> generateOperatorFactory(int[] leftKeys, int[] rightKeys, FlinkJoinType joinType, boolean[] filterNulls, RowType leftType, RowType rightType, GeneratedJoinCondition condFunc, boolean leftIsBuild, int estimatedLeftAvgRowSize, int estimatedRightAvgRowSize, long estimatedLeftRowCount, long estimatedRightRowCount, boolean tryDistinctBuildRow, long managedMemory, ReadableConfig config, ClassLoader classLoader) {
        int[] probeKeys;
        long probeRowCount;
        RowType probeType;
        GeneratedProjection probeProj;
        int[] buildKeys;
        long buildRowCount;
        int buildRowSize;
        RowType buildType;
        GeneratedProjection buildProj;
        boolean reverseJoin;
        LogicalType[] keyFieldTypes = (LogicalType[])IntStream.of(leftKeys).mapToObj(arg_0 -> ((RowType)leftType).getTypeAt(arg_0)).toArray(LogicalType[]::new);
        RowType keyType = RowType.of((LogicalType[])keyFieldTypes);
        GeneratedProjection leftProj = ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "HashJoinLeftProjection", leftType, keyType, leftKeys);
        GeneratedProjection rightProj = ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "HashJoinRightProjection", rightType, keyType, rightKeys);
        boolean bl = reverseJoin = !leftIsBuild;
        if (leftIsBuild) {
            buildProj = leftProj;
            buildType = leftType;
            buildRowSize = estimatedLeftAvgRowSize;
            buildRowCount = estimatedLeftRowCount;
            buildKeys = leftKeys;
            probeProj = rightProj;
            probeType = rightType;
            probeRowCount = estimatedRightRowCount;
            probeKeys = rightKeys;
        } else {
            buildProj = rightProj;
            buildType = rightType;
            buildRowSize = estimatedRightAvgRowSize;
            buildRowCount = estimatedRightRowCount;
            buildKeys = rightKeys;
            probeProj = leftProj;
            probeType = leftType;
            probeRowCount = estimatedLeftRowCount;
            probeKeys = leftKeys;
        }
        HashJoinType hashJoinType = HashJoinType.of((boolean)leftIsBuild, (boolean)joinType.isLeftOuter(), (boolean)joinType.isRightOuter(), (joinType == FlinkJoinType.SEMI ? 1 : 0) != 0, (joinType == FlinkJoinType.ANTI ? 1 : 0) != 0);
        long externalBufferMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        SortMergeJoinFunction sortMergeJoinFunction = SorMergeJoinOperatorUtil.getSortMergeJoinFunction(classLoader, config, joinType, leftType, rightType, leftKeys, rightKeys, keyType, leftIsBuild, filterNulls, condFunc, 1.0 * (double)externalBufferMemory / (double)managedMemory);
        boolean compressionEnabled = (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED);
        int compressionBlockSize = (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes();
        SimpleOperatorFactory operator = LongHashJoinGenerator.support(hashJoinType, keyType, filterNulls) ? LongHashJoinGenerator.gen(config, classLoader, hashJoinType, keyType, buildType, probeType, buildKeys, probeKeys, buildRowSize, buildRowCount, reverseJoin, condFunc, leftIsBuild, compressionEnabled, compressionBlockSize, sortMergeJoinFunction) : SimpleOperatorFactory.of((StreamOperator)HashJoinOperator.newHashJoinOperator((HashJoinType)hashJoinType, (boolean)leftIsBuild, (boolean)compressionEnabled, (int)compressionBlockSize, (GeneratedJoinCondition)condFunc, (boolean)reverseJoin, (boolean[])filterNulls, (GeneratedProjection)buildProj, (GeneratedProjection)probeProj, (boolean)tryDistinctBuildRow, (int)buildRowSize, (long)buildRowCount, (long)probeRowCount, (RowType)keyType, (SortMergeJoinFunction)sortMergeJoinFunction));
        return operator;
    }
}

