/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableMinusEmptyPruneRuleConfig;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableUnionEmptyPruneRuleConfig;
import org.immutables.value.Value;

public class FlinkPruneEmptyRules {
    public static final RelOptRule UNION_INSTANCE = UnionEmptyPruneRuleConfig.DEFAULT.toRule();
    public static final RelOptRule MINUS_INSTANCE = MinusEmptyPruneRuleConfig.DEFAULT.toRule();

    private static boolean isEmpty(RelNode node) {
        if (node instanceof Values) {
            return ((Values)node).getTuples().isEmpty();
        }
        if (node instanceof HepRelVertex) {
            return FlinkPruneEmptyRules.isEmpty(((HepRelVertex)node).getCurrentRel());
        }
        if (!(node instanceof RelSubset)) {
            return false;
        }
        RelSubset subset = (RelSubset)node;
        for (RelNode rel : subset.getRels()) {
            if (!FlinkPruneEmptyRules.isEmpty(rel)) continue;
            return true;
        }
        return false;
    }

    protected static abstract class FlinkPruneEmptyRule
    extends RelRule<Config>
    implements SubstitutionRule {
        protected FlinkPruneEmptyRule(Config config) {
            super(config);
        }

        @Override
        public boolean autoPruneOld() {
            return true;
        }

        public static interface Config
        extends RelRule.Config {
            @Override
            public FlinkPruneEmptyRule toRule();
        }
    }

    @Value.Immutable
    public static interface MinusEmptyPruneRuleConfig
    extends FlinkPruneEmptyRule.Config {
        public static final MinusEmptyPruneRuleConfig DEFAULT = ImmutableMinusEmptyPruneRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(Minus.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Minus");

        @Override
        default public FlinkPruneEmptyRule toRule() {
            return new FlinkPruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Minus minus = (Minus)call.rel(0);
                    List<RelNode> inputs = Objects.requireNonNull(minus.getInputs());
                    int nonEmptyInputs = 0;
                    RelBuilder relBuilder = call.builder();
                    for (RelNode input : inputs) {
                        if (!FlinkPruneEmptyRules.isEmpty(input)) {
                            relBuilder.push(input);
                            ++nonEmptyInputs;
                            continue;
                        }
                        if (nonEmptyInputs != 0) continue;
                        break;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(minus);
                    if (nonEmptyInputs == 0) {
                        relBuilder.push(minus).empty();
                    } else if (nonEmptyInputs == 1 && !minus.all) {
                        relBuilder.distinct();
                        relBuilder.convert(minus.getRowType(), true);
                    } else {
                        relBuilder.minus(minus.all, nonEmptyInputs);
                        relBuilder.convert(minus.getRowType(), true);
                    }
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }

    @Value.Immutable
    public static interface UnionEmptyPruneRuleConfig
    extends FlinkPruneEmptyRule.Config {
        public static final UnionEmptyPruneRuleConfig DEFAULT = ImmutableUnionEmptyPruneRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(Union.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Union");

        @Override
        default public FlinkPruneEmptyRule toRule() {
            return new FlinkPruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Union union = (Union)call.rel(0);
                    List<RelNode> inputs = Objects.requireNonNull(union.getInputs());
                    RelBuilder relBuilder = call.builder();
                    int nonEmptyInputs = 0;
                    for (RelNode input : inputs) {
                        if (FlinkPruneEmptyRules.isEmpty(input)) continue;
                        relBuilder.push(input);
                        ++nonEmptyInputs;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(union);
                    if (nonEmptyInputs == 0) {
                        relBuilder.push(union).empty();
                    } else if (nonEmptyInputs == 1 && !union.all) {
                        relBuilder.distinct();
                        relBuilder.convert(union.getRowType(), true);
                    } else {
                        relBuilder.union(union.all, nonEmptyInputs);
                        relBuilder.convert(union.getRowType(), true);
                    }
                    call.transformTo(relBuilder.build());
                }
            };
        }
    }
}

