/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.types.RowKind;

@Internal
final class ChangelogModeJsonDeserializer
extends StdDeserializer<ChangelogMode> {
    private static final long serialVersionUID = 1L;
    private static final String PARTIAL_DELETE = "~" + RowKind.DELETE.name();

    ChangelogModeJsonDeserializer() {
        super(ChangelogMode.class);
    }

    public ChangelogMode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        JsonNode rowKindsNode = (JsonNode)jsonParser.readValueAsTree();
        for (JsonNode rowKindNode : rowKindsNode) {
            String rowKindText = rowKindNode.asText();
            if (Objects.equals(PARTIAL_DELETE, rowKindText)) {
                builder.keyOnlyDeletes(true);
                builder.addContainedKind(RowKind.DELETE);
                continue;
            }
            RowKind rowKind = RowKind.valueOf((String)rowKindText);
            builder.addContainedKind(rowKind);
        }
        return builder.build();
    }
}

