/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.util.TimeUtils;

public enum StateTtlHint {
    STATE_TTL("STATE_TTL");

    public static final String NO_STATE_TTL = "0s";
    private final String hintName;

    private StateTtlHint(String hintName) {
        this.hintName = hintName;
    }

    public String getHintName() {
        return this.hintName;
    }

    public static boolean isStateTtlHint(String hintName) {
        try {
            String formalizedHintName = hintName.toUpperCase(Locale.ROOT);
            return StateTtlHint.valueOf(formalizedHintName) == STATE_TTL;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<Integer, Long> getStateTtlFromHintOnBiRel(List<RelHint> hints) {
        HashMap<Integer, Long> stateTtlFromHint = new HashMap<Integer, Long>();
        hints.stream().filter(hint -> StateTtlHint.isStateTtlHint(hint.hintName)).forEach(hint -> hint.kvOptions.forEach((input, ttl) -> {
            int side = "LEFT".equals(input) ? 0 : 1;
            stateTtlFromHint.put(side, TimeUtils.parseDuration((String)ttl).toMillis());
        }));
        return stateTtlFromHint;
    }

    public static Map<Integer, Long> getStateTtlFromHintOnMultiRel(List<RelHint> hints) {
        HashMap<Integer, Long> stateTtlFromHint = new HashMap<Integer, Long>();
        hints.stream().filter(hint -> StateTtlHint.isStateTtlHint(hint.hintName)).forEach(hint -> {
            List<String> ttls = hint.listOptions;
            IntStream.range(0, ttls.size()).forEach(id -> stateTtlFromHint.put(id, TimeUtils.parseDuration((String)((String)ttls.get(id))).toMillis()));
        });
        return stateTtlFromHint;
    }

    @Nullable
    public static Long getStateTtlFromHintOnSingleRel(List<RelHint> hints) {
        List allStateTtl = hints.stream().filter(hint -> StateTtlHint.isStateTtlHint(hint.hintName)).flatMap(hint -> hint.listOptions.stream()).map(ttl -> TimeUtils.parseDuration((String)ttl).toMillis()).collect(Collectors.toList());
        return allStateTtl.isEmpty() ? null : (Long)allStateTtl.get(0);
    }
}

