/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.plan.nodes.common.CommonIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecProcessTableFunction;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;

public class ExecNodeGraphGenerator {
    private final Map<FlinkPhysicalRel, ExecNode<?>> visitedRels = new IdentityHashMap();
    private final Set<String> visitedProcessTableFunctionUids = new HashSet<String>();

    public ExecNodeGraph generate(List<FlinkPhysicalRel> relNodes, boolean isCompiled) {
        ArrayList rootNodes = new ArrayList(relNodes.size());
        for (FlinkPhysicalRel relNode : relNodes) {
            rootNodes.add(this.generate(relNode, isCompiled));
        }
        return new ExecNodeGraph(rootNodes);
    }

    private ExecNode<?> generate(FlinkPhysicalRel rel, boolean isCompiled) {
        ExecNode<?> execNode = this.visitedRels.get(rel);
        if (execNode != null) {
            return execNode;
        }
        if (rel instanceof CommonIntermediateTableScan) {
            throw new TableException("Intermediate RelNode can't be converted to ExecNode.");
        }
        ArrayList inputNodes = new ArrayList();
        for (RelNode input : rel.getInputs()) {
            inputNodes.add(this.generate((FlinkPhysicalRel)input, isCompiled));
        }
        execNode = rel.translateToExecNode(isCompiled);
        ArrayList<ExecEdge> inputEdges = new ArrayList<ExecEdge>(inputNodes.size());
        for (ExecNode execNode2 : inputNodes) {
            inputEdges.add(ExecEdge.builder().source(execNode2).target(execNode).build());
        }
        execNode.setInputEdges(inputEdges);
        this.checkUidForProcessTableFunction(execNode);
        this.visitedRels.put(rel, execNode);
        return execNode;
    }

    private void checkUidForProcessTableFunction(ExecNode<?> execNode) {
        if (!(execNode instanceof StreamExecProcessTableFunction)) {
            return;
        }
        String uid = ((StreamExecProcessTableFunction)execNode).getUid();
        if (uid == null) {
            return;
        }
        if (this.visitedProcessTableFunctionUids.contains(uid)) {
            throw new ValidationException(String.format("Duplicate unique identifier '%s' detected among process table functions. Make sure that all PTF calls have an identifier defined that is globally unique. Please provide a custom identifier using the implicit `uid` argument. For example: myFunction(..., uid => 'my-id')", uid));
        }
        this.visitedProcessTableFunctionUids.add(uid);
    }
}

