/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rex.RexLiteral;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.functions.inference.AbstractSqlCallContext;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class LookupCallContext
extends AbstractSqlCallContext {
    private final List<FunctionCallUtils.FunctionParam> lookupKeys;
    private final List<DataType> argumentDataTypes;
    private final DataType outputDataType;

    public LookupCallContext(DataTypeFactory dataTypeFactory, UserDefinedFunction function, final LogicalType inputType, final List<FunctionCallUtils.FunctionParam> lookupKeys, LogicalType lookupType) {
        super(dataTypeFactory, (FunctionDefinition)function, UserDefinedFunctionHelper.generateInlineFunctionName((UserDefinedFunction)function), false);
        this.lookupKeys = lookupKeys;
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int index) {
                LogicalType keyType;
                FunctionCallUtils.FunctionParam key = LookupCallContext.this.getKey(index);
                if (key instanceof FunctionCallUtils.Constant) {
                    keyType = ((FunctionCallUtils.Constant)key).sourceType;
                } else if (key instanceof FunctionCallUtils.FieldRef) {
                    keyType = (LogicalType)LogicalTypeChecks.getFieldTypes((LogicalType)inputType).get(((FunctionCallUtils.FieldRef)key).index);
                } else {
                    throw new IllegalArgumentException();
                }
                return TypeConversions.fromLogicalToDataType((LogicalType)keyType);
            }

            @Override
            public int size() {
                return lookupKeys.size();
            }
        };
        this.outputDataType = TypeConversions.fromLogicalToDataType((LogicalType)lookupType);
    }

    public boolean isArgumentLiteral(int pos) {
        return this.getKey(pos) instanceof FunctionCallUtils.Constant;
    }

    public boolean isArgumentNull(int pos) {
        FunctionCallUtils.Constant key = (FunctionCallUtils.Constant)this.getKey(pos);
        return key.literal.isNull();
    }

    public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
        if (this.isArgumentNull(pos)) {
            return Optional.empty();
        }
        try {
            FunctionCallUtils.Constant key = (FunctionCallUtils.Constant)this.getKey(pos);
            RexLiteral literal = key.literal;
            return Optional.ofNullable(LookupCallContext.getLiteralValueAs(literal::getValueAs, clazz));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    public Optional<DataType> getOutputDataType() {
        return Optional.of(this.outputDataType);
    }

    private FunctionCallUtils.FunctionParam getKey(int pos) {
        return this.lookupKeys.get(pos);
    }
}

