/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.util.format.FormatElement;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public enum FormatElementEnum implements FormatElement
{
    D("The weekday (Monday as the first day of the week) as a decimal number (1-7)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%d", calendar.get(7));
        }
    }
    ,
    DAY("The full weekday name"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.eeeeFormat.format(date);
        }
    }
    ,
    DD("The day of the month as a decimal number (01-31)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%02d", calendar.get(5));
        }
    }
    ,
    DDD("The day of the year as a decimal number (001-366)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%03d", calendar.get(6));
        }
    }
    ,
    DY("The abbreviated weekday name"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.eeeFormat.format(date);
        }
    }
    ,
    FF1("Fractional seconds to 1 digit"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.sFormat.format(date);
        }
    }
    ,
    FF2("Fractional seconds to 2 digits"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.ssFormat.format(date);
        }
    }
    ,
    FF3("Fractional seconds to 3 digits"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.sssFormat.format(date);
        }
    }
    ,
    FF4("Fractional seconds to 4 digits"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.ssssFormat.format(date);
        }
    }
    ,
    FF5("Fractional seconds to 5 digits"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.sssssFormat.format(date);
        }
    }
    ,
    FF6("Fractional seconds to 6 digits"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.ssssssFormat.format(date);
        }
    }
    ,
    HH24("The hour (24-hour clock) as a decimal number (00-23)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%02d", calendar.get(11));
        }
    }
    ,
    IW("The ISO 8601 week number of the year (Monday as the first day of the week) as a decimal number (01-53)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            calendar.setFirstDayOfWeek(2);
            return String.format(Locale.ROOT, "%02d", calendar.get(3));
        }
    }
    ,
    MI("The minute as a decimal number (00-59)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%02d", calendar.get(12));
        }
    }
    ,
    MM("The month as a decimal number (01-12)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%02d", calendar.get(2) + 1);
        }
    }
    ,
    MON("The abbreviated month name"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.mmmFormat.format(date);
        }
    }
    ,
    MONTH("The full month name (English)"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.mmmmFormat.format(date);
        }
    }
    ,
    Q("The quarter as a decimal number (1-4)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%d", calendar.get(2) / 3 + 1);
        }
    }
    ,
    SS("The second as a decimal number (00-60)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%02d", calendar.get(13));
        }
    }
    ,
    TZR("The time zone name"){

        @Override
        public String format(Date date) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    WW("The week number of the year (Sunday as the first day of the week) as a decimal number (00-53)"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            calendar.setFirstDayOfWeek(1);
            return String.format(Locale.ROOT, "%02d", calendar.get(3));
        }
    }
    ,
    YY("Last 2 digits of year"){

        @Override
        public String format(Date date) {
            Work work = Work.get();
            return work.yyFormat.format(date);
        }
    }
    ,
    YYYY("The year with century as a decimal number"){

        @Override
        public String format(Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            return String.format(Locale.ROOT, "%d", calendar.get(1));
        }
    };

    private final String description;

    private FormatElementEnum(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static class Work {
        private static final ThreadLocal<@Nullable Work> THREAD_WORK = ThreadLocal.withInitial(Work::new);
        final Calendar calendar = Calendar.getInstance(DateTimeUtils.DEFAULT_ZONE, Locale.ROOT);
        final DateFormat eeeeFormat = new SimpleDateFormat("EEEE", Locale.ROOT);
        final DateFormat eeeFormat = new SimpleDateFormat("EEE", Locale.ROOT);
        final DateFormat mmmFormat = new SimpleDateFormat("MMM", Locale.ROOT);
        final DateFormat mmmmFormat = new SimpleDateFormat("MMMM", Locale.ROOT);
        final DateFormat sFormat = new SimpleDateFormat("S", Locale.ROOT);
        final DateFormat ssFormat = new SimpleDateFormat("SS", Locale.ROOT);
        final DateFormat sssFormat = new SimpleDateFormat("SSS", Locale.ROOT);
        final DateFormat ssssFormat = new SimpleDateFormat("SSSS", Locale.ROOT);
        final DateFormat sssssFormat = new SimpleDateFormat("SSSSS", Locale.ROOT);
        final DateFormat ssssssFormat = new SimpleDateFormat("SSSSSS", Locale.ROOT);
        final DateFormat yyFormat = new SimpleDateFormat("yy", Locale.ROOT);

        Work() {
        }

        static Work get() {
            return Nullness.castNonNull(THREAD_WORK.get());
        }
    }
}

