/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.util.OptionalInt;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.state.api.KeyedStateTransformation;
import org.apache.flink.state.api.SavepointWriterOperatorFactory;
import org.apache.flink.state.api.StateBootstrapTransformation;
import org.apache.flink.state.api.functions.BroadcastStateBootstrapFunction;
import org.apache.flink.state.api.functions.StateBootstrapFunction;
import org.apache.flink.state.api.output.operators.BroadcastStateBootstrapOperator;
import org.apache.flink.state.api.output.operators.StateBootstrapOperator;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;

@PublicEvolving
public class OneInputStateTransformation<T> {
    private final DataStream<T> stream;
    private final long checkpointId;
    private OptionalInt operatorMaxParallelism = OptionalInt.empty();

    OneInputStateTransformation(DataStream<T> stream, long checkpointId) {
        this.stream = stream;
        this.checkpointId = checkpointId;
    }

    @PublicEvolving
    public OneInputStateTransformation<T> setMaxParallelism(int maxParallelism) {
        this.operatorMaxParallelism = OptionalInt.of(maxParallelism);
        return this;
    }

    public StateBootstrapTransformation<T> transform(StateBootstrapFunction<T> processFunction) {
        SavepointWriterOperatorFactory factory = (timestamp, path) -> SimpleOperatorFactory.of(new StateBootstrapOperator(this.checkpointId, timestamp, path, processFunction));
        return this.transform(factory);
    }

    public StateBootstrapTransformation<T> transform(BroadcastStateBootstrapFunction<T> processFunction) {
        SavepointWriterOperatorFactory factory = (timestamp, path) -> SimpleOperatorFactory.of(new BroadcastStateBootstrapOperator(this.checkpointId, timestamp, path, processFunction));
        return this.transform(factory);
    }

    public StateBootstrapTransformation<T> transform(SavepointWriterOperatorFactory factory) {
        return new StateBootstrapTransformation<T>(this.stream, this.operatorMaxParallelism, factory);
    }

    public <K> KeyedStateTransformation<K, T> keyBy(KeySelector<T, K> keySelector) {
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, (TypeInformation)this.stream.getType());
        return new KeyedStateTransformation<K, T>(this.stream, this.checkpointId, this.operatorMaxParallelism, keySelector, keyType);
    }

    public <K> KeyedStateTransformation<K, T> keyBy(KeySelector<T, K> keySelector, TypeInformation<K> keyType) {
        return new KeyedStateTransformation<K, T>(this.stream, this.checkpointId, this.operatorMaxParallelism, keySelector, keyType);
    }

    public KeyedStateTransformation<Tuple, T> keyBy(int ... fields) {
        if (this.stream.getType() instanceof BasicArrayTypeInfo || this.stream.getType() instanceof PrimitiveArrayTypeInfo) {
            return this.keyBy((KeySelector)KeySelectorUtil.getSelectorForArray((int[])fields, (TypeInformation)this.stream.getType()));
        }
        return this.keyBy((Keys<T>)new Keys.ExpressionKeys(fields, this.stream.getType()));
    }

    public KeyedStateTransformation<Tuple, T> keyBy(String ... fields) {
        return this.keyBy((Keys<T>)new Keys.ExpressionKeys(fields, this.stream.getType()));
    }

    private KeyedStateTransformation<Tuple, T> keyBy(Keys<T> keys) {
        KeySelector keySelector = KeySelectorUtil.getSelectorForKeys(keys, (TypeInformation)this.stream.getType(), (ExecutionConfig)this.stream.getExecutionEnvironment().getConfig());
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes((KeySelector)keySelector, (TypeInformation)this.stream.getType());
        return new KeyedStateTransformation(this.stream, this.checkpointId, this.operatorMaxParallelism, keySelector, keyType);
    }
}

