/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.prometheus.PrometheusPushGatewayReporter;
import org.apache.flink.metrics.prometheus.PrometheusPushGatewayReporterOptions;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusPushGatewayReporterFactory
implements MetricReporterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusPushGatewayReporterFactory.class);

    public PrometheusPushGatewayReporter createMetricReporter(Properties properties) {
        MetricConfig metricConfig = (MetricConfig)properties;
        String configuredJobName = metricConfig.getString(PrometheusPushGatewayReporterOptions.JOB_NAME.key(), (String)PrometheusPushGatewayReporterOptions.JOB_NAME.defaultValue());
        boolean randomSuffix = metricConfig.getBoolean(PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.key(), ((Boolean)PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.defaultValue()).booleanValue());
        boolean deleteOnShutdown = metricConfig.getBoolean(PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.key(), ((Boolean)PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.defaultValue()).booleanValue());
        Map<String, String> groupingKey = PrometheusPushGatewayReporterFactory.parseGroupingKey(metricConfig.getString(PrometheusPushGatewayReporterOptions.GROUPING_KEY.key(), (String)PrometheusPushGatewayReporterOptions.GROUPING_KEY.defaultValue()));
        String hostUrl = metricConfig.getString(PrometheusPushGatewayReporterOptions.HOST_URL.key(), (String)PrometheusPushGatewayReporterOptions.HOST_URL.defaultValue());
        if (StringUtils.isNullOrWhitespaceOnly((String)hostUrl)) {
            throw new IllegalArgumentException("hostUrl must not be null or empty");
        }
        Object jobName = configuredJobName;
        if (randomSuffix) {
            jobName = configuredJobName + String.valueOf(new AbstractID());
        }
        LOG.info("Configured PrometheusPushGatewayReporter with {hostUrl:{}, jobName:{}, randomJobNameSuffix:{}, deleteOnShutdown:{}, groupingKey:{}}", new Object[]{hostUrl, jobName, randomSuffix, deleteOnShutdown, groupingKey});
        try {
            return new PrometheusPushGatewayReporter(new URL(hostUrl), (String)jobName, groupingKey, deleteOnShutdown);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static Map<String, String> parseGroupingKey(String groupingKeyConfig) {
        if (!groupingKeyConfig.isEmpty()) {
            String[] kvs;
            HashMap<String, String> groupingKey = new HashMap<String, String>();
            for (String kv : kvs = groupingKeyConfig.split(";")) {
                int idx = kv.indexOf("=");
                if (idx < 0) {
                    LOG.warn("Invalid prometheusPushGateway groupingKey:{}, will be ignored", (Object)kv);
                    continue;
                }
                String labelKey = kv.substring(0, idx);
                String labelValue = kv.substring(idx + 1);
                if (StringUtils.isNullOrWhitespaceOnly((String)labelKey) || StringUtils.isNullOrWhitespaceOnly((String)labelValue)) {
                    LOG.warn("Invalid groupingKey {labelKey:{}, labelValue:{}} must not be empty", (Object)labelKey, (Object)labelValue);
                    continue;
                }
                groupingKey.put(labelKey, labelValue);
            }
            return groupingKey;
        }
        return Collections.emptyMap();
    }
}

